/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.api.util.MappingUtil;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.PressModel;
import com.hollingsworth.arsnouveau.common.block.tile.GlyphPressTile;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class PressRenderer
extends GeoBlockRenderer<GlyphPressTile> {
    public PressRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn, (AnimatedGeoModel)new PressModel());
    }

    public void renderFloatingItem(GlyphPressTile tileEntityIn, ItemEntity entityItem, double x, double y, double z, MatrixStack stack, IRenderTypeBuffer iRenderTypeBuffer) {
        stack.func_227860_a_();
        ++tileEntityIn.frames;
        entityItem.func_70034_d((float)tileEntityIn.frames);
        ObfuscationReflectionHelper.setPrivateValue(ItemEntity.class, (Object)entityItem, (Object)((int)(800.0f - (float)tileEntityIn.frames)), (String)MappingUtil.getItemEntityAge());
        Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)entityItem, 0.5, 1.0, 0.5, entityItem.field_70177_z, 2.0f, stack, iRenderTypeBuffer, 0xF000F0);
        Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entityItem);
        stack.func_227865_b_();
    }

    public void renderPressedItem(double x, double y, double z, Item itemToRender, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, int il) {
        matrixStack.func_227860_a_();
        Direction direction1 = Direction.func_176731_b((int)((1 + Direction.NORTH.func_176736_b()) % 4));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-direction1.func_185119_l()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, -0.2);
        matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)itemToRender), ItemCameraTransforms.TransformType.NONE, 150, il, matrixStack, iRenderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    public void renderEarly(GlyphPressTile tileEntityIn, MatrixStack matrixStack, float ticks, IRenderTypeBuffer iRenderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        double x = tileEntityIn.func_174877_v().func_177958_n();
        double y = tileEntityIn.func_174877_v().func_177956_o();
        double z = tileEntityIn.func_174877_v().func_177952_p();
        if (tileEntityIn.baseMaterial == null || tileEntityIn.baseMaterial.func_190926_b()) {
            return;
        }
        if (tileEntityIn.entity == null || !ItemStack.func_77989_b((ItemStack)tileEntityIn.entity.func_92059_d(), (ItemStack)tileEntityIn.reagentItem)) {
            tileEntityIn.entity = new ItemEntity(tileEntityIn.func_145831_w(), x, y, z, tileEntityIn.reagentItem);
        }
        x += 0.5;
        y += 0.9;
        z += 0.5;
        if (tileEntityIn.counter <= 40) {
            this.renderPressedItem(x, y, z, tileEntityIn.baseMaterial.func_77973_b(), matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        } else if (tileEntityIn.counter <= 110) {
            this.renderPressedItem(x, y, z, ItemsRegistry.blankGlyph, matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        } else {
            this.renderPressedItem(x, y, z, tileEntityIn.baseMaterial.func_77973_b(), matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        }
        if (tileEntityIn.counter > 70 && tileEntityIn.counter < 120) {
            BlockPos pos = tileEntityIn.func_174877_v();
            World world = tileEntityIn.func_145831_w();
            if (world.func_82737_E() % 3L != 0L) {
                return;
            }
            for (int i = 0; i < 1; ++i) {
                double posX = pos.func_177958_n();
                double posY = pos.func_177956_o();
                double posZ = pos.func_177952_p();
                double randX = (double)world.field_73012_v.nextFloat() > 0.5 ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat());
                double randZ = (double)world.field_73012_v.nextFloat() > 0.5 ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat());
                double d0 = posX + 0.5 + randX * 0.2;
                double d1 = posY + 0.4;
                double d2 = posZ + 0.5 + randZ * 0.2;
                double spdX = (double)world.field_73012_v.nextFloat() > 0.5 ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat());
                double spdZ = (double)world.field_73012_v.nextFloat() > 0.5 ? (double)world.field_73012_v.nextFloat() : (double)(-world.field_73012_v.nextFloat());
                world.func_195594_a((IParticleData)ParticleTypes.field_197622_o, d0, d1, d2, spdX * 0.05, 0.0, spdZ * 0.05);
            }
        }
    }

    public static GenericItemRenderer getISTER() {
        return new GenericItemRenderer(new PressModel());
    }
}

