/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class WildenGuardianModel
extends AnimatedGeoModel<WildenGuardian> {
    public static final ResourceLocation WARDER_NEUTRAL = new ResourceLocation("ars_nouveau", "geo/wilden_warder_neutral.geo.json");
    public static final ResourceLocation WARDER_ARMORED = new ResourceLocation("ars_nouveau", "geo/wilden_warder_defense.geo.json");
    public static final ResourceLocation TEXT = new ResourceLocation("ars_nouveau", "textures/entity/warder.png");
    public static final ResourceLocation ANIM = new ResourceLocation("ars_nouveau", "animations/wilden_warder_animation_neutral.geo.json");

    public void setLivingAnimations(WildenGuardian entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        IBone frontLeftLeg = this.getAnimationProcessor().getBone("left_leg");
        IBone frontRightLeg = this.getAnimationProcessor().getBone("right_leg");
        frontLeftLeg.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f)) * 1.4f * entity.field_70721_aZ);
        frontRightLeg.setRotationX(MathHelper.func_76134_b((float)(entity.field_184619_aG * 0.6662f + (float)Math.PI)) * 1.4f * entity.field_70721_aZ);
    }

    public ResourceLocation getModelLocation(WildenGuardian wildenStalker) {
        return wildenStalker.isArmored() ? WARDER_ARMORED : WARDER_NEUTRAL;
    }

    public ResourceLocation getTextureLocation(WildenGuardian wildenStalker) {
        return TEXT;
    }

    public ResourceLocation getAnimationFileLocation(WildenGuardian wildenStalker) {
        return ANIM;
    }
}

