/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.renderer.entity.CarbuncleModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.ArmorItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class ModelLayerRenderer<T extends Entity>
extends GeoLayerRenderer
implements IGeoRenderer<T> {
    AnimatedGeoModel geoModelProvider;
    private static Map<Class<? extends ArmorItem>, GeoArmorRenderer> renderers = new ConcurrentHashMap<Class<? extends ArmorItem>, GeoArmorRenderer>();

    public ModelLayerRenderer(IGeoRenderer<T> entityRendererIn, AnimatedGeoModel modelProvider) {
        super(entityRendererIn);
        this.geoModelProvider = modelProvider;
    }

    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.geoModelProvider;
    }

    public ResourceLocation getTextureLocation(T instance) {
        return this.geoModelProvider.getTextureLocation(instance);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.func_227860_a_();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.headPitch = headPitch;
        entityModelData.netHeadYaw = netHeadYaw;
        GeoModel model = this.geoModelProvider.getModel(this.geoModelProvider.getModelLocation((Object)entity));
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entity, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        IBone carbuncle = ((CarbuncleModel)this.getEntityModel()).getBone("carbuncle");
        this.geoModelProvider.setLivingAnimations((IAnimatable)entity, this.getUniqueID(entity), predicate);
        IBone head = ((CarbuncleModel)this.getEntityModel()).getBone("head");
        matrixStackIn.func_227861_a_((double)(carbuncle.getPositionX() / 32.0f), (double)(carbuncle.getPositionY() / 16.0f), (double)carbuncle.getPositionZ());
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(carbuncle.getRotationZ());
        matrixStackIn.func_227863_a_(quaternion);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation((T)entity));
        Color renderColor = this.getRenderColor(entity, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entity, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.getTextureLocation((T)entity));
        this.render(model, entity, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, OverlayTexture.field_229196_a_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        matrixStackIn.func_227865_b_();
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                // empty if block
            }
            return null;
        });
    }
}

