/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.util.PortalFrameTester;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FlatPortalAreaHelper
extends PortalFrameTester {
    public int xSize = -1;
    public int zSize = -1;
    public final int maxXSize = 21;
    public final int maxZSize = 21;

    @Override
    public FlatPortalAreaHelper init(World world, BlockPos blockPos, Direction.Axis axis, Predicate<BlockState> foundations) {
        this.VALID_FRAME = foundations;
        this.world = world;
        this.lowerCorner = this.getLowerCorner(blockPos, Direction.Axis.X, Direction.Axis.Z);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 0;
            this.xSize = 0;
        } else {
            this.xSize = this.getSize(Direction.Axis.X, 1, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(Direction.Axis.Z, 1, 21);
                if (this.checkForValidFrame(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(World worldAccess, BlockPos blockPos, Direction.Axis axis, Predicate<BlockState> foundations) {
        return this.getOrEmpty(worldAccess, blockPos, areaHelper -> areaHelper.isValidFrame() && areaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(World worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Predicate<BlockState> foundations) {
        return Optional.of(new FlatPortalAreaHelper().init(worldAccess, blockPos, axis, (Predicate)foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.xSize * this.zSize;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 1 && this.zSize >= 1 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(Block frameBlock) {
        BlockPos.func_218278_a((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.func_241872_a(Direction.Axis.X, this.xSize - 1).func_241872_a(Direction.Axis.Z, this.zSize - 1)).forEach(blockPos -> this.world.func_180501_a(blockPos, Blocks.field_196604_cC.func_176223_P(), 18));
    }

    @Override
    public void createPortal(World world, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        for (i = -1; i < 3; ++i) {
            world.func_175656_a(pos.func_241872_a(Direction.Axis.X, i).func_241872_a(Direction.Axis.Z, -1), frameBlock);
            world.func_175656_a(pos.func_241872_a(Direction.Axis.X, i).func_241872_a(Direction.Axis.Z, 2), frameBlock);
            world.func_175656_a(pos.func_241872_a(Direction.Axis.Z, i).func_241872_a(Direction.Axis.X, -1), frameBlock);
            world.func_175656_a(pos.func_241872_a(Direction.Axis.Z, i).func_241872_a(Direction.Axis.X, 2), frameBlock);
        }
        for (i = 0; i < 2; ++i) {
            this.placeLandingPad(world, pos.func_241872_a(Direction.Axis.X, i).func_177977_b(), frameBlock);
            this.placeLandingPad(world, pos.func_241872_a(Direction.Axis.X, i).func_241872_a(Direction.Axis.Z, 1).func_177977_b(), frameBlock);
            this.fillAirAroundPortal(world, pos.func_241872_a(Direction.Axis.X, i).func_177984_a());
            this.fillAirAroundPortal(world, pos.func_241872_a(Direction.Axis.X, i).func_241872_a(Direction.Axis.Z, 1).func_177984_a());
            this.fillAirAroundPortal(world, pos.func_241872_a(Direction.Axis.X, i).func_177981_b(2));
            this.fillAirAroundPortal(world, pos.func_241872_a(Direction.Axis.X, i).func_241872_a(Direction.Axis.Z, 1).func_177981_b(2));
        }
        this.lowerCorner = pos;
        this.zSize = 2;
        this.xSize = 2;
        this.world = world;
        this.foundPortalBlocks = 4;
        this.lightPortal(frameBlock.func_177230_c());
    }

    private void fillAirAroundPortal(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void placeLandingPad(World world, BlockPos pos, BlockState frameBlock) {
        if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            world.func_175656_a(pos, frameBlock);
        }
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return (this.xSize == attemptWidth || attemptHeight == 0) && this.zSize == attemptHeight || attemptWidth == 0 || (this.xSize == attemptHeight || attemptHeight == 0) && (this.zSize == attemptWidth || attemptWidth == 0);
    }

    @Override
    public Direction.Axis getAxis1() {
        return Direction.Axis.X;
    }

    @Override
    public Direction.Axis getAxis2() {
        return Direction.Axis.Z;
    }

    @Override
    public BlockPos doesPortalFitAt(World world, BlockPos attemptPos, Direction.Axis axis) {
        return attemptPos;
    }
}

