/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AbstractRitual {
    public RitualTile tile;
    private RitualContext context;
    public Random rand = new Random();

    public AbstractRitual() {
    }

    public AbstractRitual(RitualTile tile, RitualContext context) {
        this.tile = tile;
        this.setContext(context);
    }

    public void tryTick() {
        if (this.tile == null || !this.getContext().isStarted || this.getContext().isDone) {
            return;
        }
        this.tick();
    }

    @Nullable
    public BlockPos getPos() {
        return this.tile != null ? this.tile.func_174877_v() : null;
    }

    @Nullable
    public World getWorld() {
        return this.tile != null ? this.tile.func_145831_w() : null;
    }

    public boolean canStart() {
        return true;
    }

    public List<ItemStack> getConsumedItems() {
        return this.getContext().consumedItems;
    }

    public boolean canConsumeItem(ItemStack stack) {
        return false;
    }

    public void onItemConsumed(ItemStack stack) {
        this.getConsumedItems().add(stack.func_77946_l());
        stack.func_190918_g(1);
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.func_174877_v());
    }

    public boolean didConsumeItem(Item item) {
        for (ItemStack i : this.getConsumedItems()) {
            if (i.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public void incrementProgress() {
        ++this.getContext().progress;
    }

    public int getProgress() {
        return this.getContext().progress;
    }

    public void onStart() {
        this.getContext().isStarted = true;
    }

    public boolean isRunning() {
        return this.getContext().isStarted && !this.getContext().isDone;
    }

    public boolean isDone() {
        return this.getContext().isDone;
    }

    public void setFinished() {
        this.getContext().isDone = true;
    }

    protected abstract void tick();

    public void onEnd() {
        this.getContext().isDone = true;
    }

    public abstract String getID();

    public String getName() {
        return new TranslationTextComponent("item.ars_nouveau.ritual_" + this.getID()).getString();
    }

    public String getDescription() {
        return new TranslationTextComponent("ars_nouveau.ritual_desc." + this.getID()).getString();
    }

    public int getManaCost() {
        return 0;
    }

    public boolean consumesMana() {
        return this.getManaCost() > 0;
    }

    public void setNeedsMana(boolean needMana) {
        this.getContext().needsManaToRun = needMana;
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.func_174877_v());
    }

    public boolean needsManaNow() {
        return this.getContext().needsManaToRun;
    }

    public void write(CompoundNBT tag) {
        CompoundNBT contextTag = new CompoundNBT();
        this.getContext().write(contextTag);
        tag.func_218657_a("context", (INBT)contextTag);
    }

    public void read(CompoundNBT tag) {
        this.setContext(RitualContext.read(tag.func_74775_l("context")));
    }

    @Nonnull
    public RitualContext getContext() {
        if (this.context == null) {
            this.context = new RitualContext();
        }
        return this.context;
    }

    public void setContext(RitualContext context) {
        this.context = context;
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(255), this.rand.nextInt(22), this.rand.nextInt(255));
    }

    public ParticleColor getOuterColor() {
        return this.getCenterColor();
    }

    public int getParticleIntensity() {
        return 50;
    }

    public String getLangName() {
        return "";
    }

    public String getLangDescription() {
        return "";
    }
}

