/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EnchantingApparatusRecipe
implements IEnchantingRecipe {
    public Ingredient reagent;
    public ItemStack result;
    public List<Ingredient> pedestalItems;
    public String category;
    public ResourceLocation id;
    public int manaCost;

    public EnchantingApparatusRecipe(ItemStack result, Ingredient reagent, List<Ingredient> pedestalItems, String category) {
        this.reagent = reagent;
        this.pedestalItems = pedestalItems;
        this.result = result;
        this.category = category;
        this.manaCost = 0;
        this.id = new ResourceLocation("ars_nouveau", result.func_77973_b().getRegistryName().func_110623_a());
    }

    public EnchantingApparatusRecipe(ResourceLocation id, List<Ingredient> pedestalItems, Ingredient reagent, ItemStack result) {
        this(id, pedestalItems, reagent, result, 0);
    }

    public EnchantingApparatusRecipe(ResourceLocation id, List<Ingredient> pedestalItems, Ingredient reagent, ItemStack result, int cost) {
        this.reagent = reagent;
        this.pedestalItems = pedestalItems;
        this.result = result;
        this.category = "";
        this.manaCost = cost;
        this.id = id;
    }

    public EnchantingApparatusRecipe() {
        this.reagent = Ingredient.field_193370_a;
        this.result = ItemStack.field_190927_a;
        this.pedestalItems = new ArrayList<Ingredient>();
        this.manaCost = 0;
        this.id = new ResourceLocation("ars_nouveau", "empty");
    }

    public EnchantingApparatusRecipe(Item result, Item reagent, Item[] pedestalItems, String category) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (Item i : pedestalItems) {
            stacks.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{i}));
        }
        this.reagent = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{reagent});
        this.result = new ItemStack((IItemProvider)result);
        this.pedestalItems = stacks;
        this.category = category;
        this.manaCost = 0;
        this.id = new ResourceLocation("ars_nouveau", result.getRegistryName().func_110623_a());
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable PlayerEntity player) {
        pedestalItems = pedestalItems.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        return this.doesReagentMatch(reagent) && this.pedestalItems.size() == pedestalItems.size() && EnchantingApparatusRecipe.doItemsMatch(pedestalItems, this.pedestalItems);
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return this.reagent.test(reag);
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        return this.result.func_77946_l();
    }

    static boolean doItemsMatch(List<ItemStack> inputs, List<Ingredient> recipeItems) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        for (ItemStack i : inputs) {
            recipeitemhelper.func_221264_a(i, 1);
        }
        return inputs.size() == recipeItems.size() && RecipeMatcher.findMatches(inputs, recipeItems) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantingApparatusRecipe that = (EnchantingApparatusRecipe)o;
        return Objects.equals(this.reagent, that.reagent) && Objects.equals(this.pedestalItems, that.pedestalItems);
    }

    public int hashCode() {
        return Objects.hash(this.reagent, this.pedestalItems);
    }

    public String toString() {
        return "EnchantingApparatusRecipe{catalyst=" + this.reagent + ", result=" + this.result + ", pedestalItems=" + this.pedestalItems + '}';
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:enchanting_apparatus");
        int counter = 1;
        for (Ingredient i : this.pedestalItems) {
            JsonArray item = new JsonArray();
            item.add(i.func_200304_c());
            jsonobject.add("item_" + counter, (JsonElement)item);
            ++counter;
        }
        JsonArray reagent = new JsonArray();
        reagent.add(this.reagent.func_200304_c());
        jsonobject.add("reagent", (JsonElement)reagent);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", this.result.func_77973_b().getRegistryName().toString());
        int count = this.result.func_190916_E();
        if (count > 1) {
            resultObj.addProperty("count", (Number)count);
        }
        jsonobject.add("output", (JsonElement)resultObj);
        jsonobject.addProperty("sourceCost", (Number)this.manaCost);
        return jsonobject;
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.result.func_77973_b().func_77658_a());
        jsonobject.addProperty("icon", this.result.func_77973_b().getRegistryName().toString());
        jsonobject.addProperty("category", this.category);
        JsonArray jsonArray = new JsonArray();
        JsonObject descPage = new JsonObject();
        descPage.addProperty("type", "text");
        descPage.addProperty("text", "ars_nouveau.page." + this.result.func_77973_b().getRegistryName().toString().replace("ars_nouveau:", ""));
        JsonObject infoPage = new JsonObject();
        infoPage.addProperty("type", "apparatus_recipe");
        infoPage.addProperty("recipe", this.result.func_77973_b().getRegistryName().toString());
        jsonArray.add((JsonElement)descPage);
        jsonArray.add((JsonElement)infoPage);
        jsonobject.add("pages", (JsonElement)jsonArray);
        return jsonobject;
    }

    @Override
    public boolean consumesMana() {
        return this.manaCost() > 0;
    }

    @Override
    public int manaCost() {
        return this.manaCost;
    }

    public boolean matches(EnchantingApparatusTile tile, World worldIn) {
        return this.isMatch(tile.getPedestalItems(), tile.catalystItem, tile, null);
    }

    public boolean matches(EnchantingApparatusTile tile, World worldIn, @Nullable PlayerEntity playerEntity) {
        return this.isMatch(tile.getPedestalItems(), tile.catalystItem, tile, playerEntity);
    }

    public ItemStack assemble(EnchantingApparatusTile inv) {
        return this.result;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeRegistry.APPARATUS_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("ars_nouveau", "enchanting_apparatus"));
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<EnchantingApparatusRecipe> {
        public EnchantingApparatusRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient reagent = Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"reagent"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            int cost = json.has("sourceCost") ? JSONUtils.func_151203_m((JsonObject)json, (String)"sourceCost") : 0;
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 1; i < 9; ++i) {
                if (!json.has("item_" + i)) continue;
                stacks.add(Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)("item_" + i))));
            }
            return new EnchantingApparatusRecipe(recipeId, stacks, reagent, output, cost);
        }

        @Nullable
        public EnchantingApparatusRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int length = buffer.readInt();
            Ingredient reagent = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.func_199566_b((PacketBuffer)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            int cost = buffer.readInt();
            return new EnchantingApparatusRecipe(recipeId, stacks, reagent, output, cost);
        }

        public void toNetwork(PacketBuffer buf, EnchantingApparatusRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            recipe.reagent.func_199564_a(buf);
            buf.func_150788_a(recipe.result);
            for (Ingredient i : recipe.pedestalItems) {
                i.func_199564_a(buf);
            }
            buf.writeInt(recipe.manaCost);
        }
    }
}

