/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.item;

import cofh.archersparadox.inventory.container.QuiverContainer;
import cofh.core.item.InventoryContainerItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.item.IColorableItem;
import cofh.lib.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class QuiverItem
extends InventoryContainerItem
implements IColorableItem,
IDyeableArmorItem,
INamedContainerProvider {
    public QuiverItem(Item.Properties builder, int slots) {
        super(builder, slots);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerColorable((Item)this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return true;
    }

    protected SimpleItemInv readInventoryFromNBT(ItemStack container) {
        CompoundNBT containerTag = this.getOrCreateInvTag(container);
        int numSlots = this.getContainerSlots(container);
        ArrayList<ItemStorageCoFH> invSlots = new ArrayList<ItemStorageCoFH>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            invSlots.add(new ItemStorageCoFH());
        }
        SimpleItemInv inventory = new SimpleItemInv(invSlots){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 0 || slot >= this.getSlots()) {
                    return false;
                }
                return stack.func_77973_b().func_206844_a((ITag)ItemTags.field_219776_M);
            }
        };
        inventory.read(containerTag);
        return inventory;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("item.archers_paradox.quiver");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new QuiverContainer(i, inventory, player);
    }
}

