/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client;

import com.teammetallurgy.aquaculture.client.gui.screen.TackleBoxScreen;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaBobberRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.AquaFishRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.FishMountRenderer;
import com.teammetallurgy.aquaculture.client.renderer.entity.TurtleLandRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.NeptunesBountyRenderer;
import com.teammetallurgy.aquaculture.client.renderer.tileentity.TackleBoxRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.item.DyeableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquaculture", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    public static void setupClient() {
        ScreenManager.func_216911_a(AquaGuis.TACKLE_BOX, TackleBoxScreen::new);
        ClientRegistry.bindTileEntityRenderer(AquaBlocks.AquaTileEntities.NEPTUNES_BOUNTY, NeptunesBountyRenderer::new);
        ClientRegistry.bindTileEntityRenderer(AquaBlocks.AquaTileEntities.TACKLE_BOX, TackleBoxRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.BOBBER, AquaBobberRenderer::new);
        for (EntityType<AquaFishEntity> entityType : FishRegistry.fishEntities) {
            RenderingRegistry.registerEntityRenderingHandler(entityType, manager -> new AquaFishRenderer(manager, fish.getRegistryName() != null && fish.getRegistryName().equals((Object)new ResourceLocation("aquaculture", "jellyfish"))));
        }
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.WATER_ARROW, TippedArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.SPECTRAL_WATER_ARROW, SpectralArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.BOX_TURTLE, TurtleLandRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.ARRAU_TURTLE, TurtleLandRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(AquaEntities.STARSHELL_TURTLE, TurtleLandRenderer::new);
        for (EntityType entityType : FishRegistry.fishMounts) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entityType, FishMountRenderer::new);
        }
        ItemColors itemColor = Minecraft.func_71410_x().getItemColors();
        itemColor.func_199877_a((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{AquaItems.FISHING_LINE, AquaItems.BOBBER});
        ClientHandler.registerFishingRodModelProperties(AquaItems.IRON_FISHING_ROD);
        ClientHandler.registerFishingRodModelProperties(AquaItems.GOLD_FISHING_ROD);
        ClientHandler.registerFishingRodModelProperties(AquaItems.DIAMOND_FISHING_ROD);
        ClientHandler.registerFishingRodModelProperties(AquaItems.NEPTUNIUM_FISHING_ROD);
        ClientHandler.registerBowModelProperties(AquaItems.NEPTUNIUM_BOW);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.OAK);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.SPRUCE);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.BIRCH);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.JUNGLE);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.ACACIA);
        ModelLoader.addSpecialModel((ResourceLocation)FishMountRenderer.DARK_OAK);
    }

    public static void registerFishingRodModelProperties(Item fishingRod) {
        ItemModelsProperties.func_239418_a_((Item)fishingRod, (ResourceLocation)new ResourceLocation("cast"), (heldStack, world, livingEntity) -> {
            boolean isOffHand;
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean isMainhand = livingEntity.func_184614_ca() == heldStack;
            boolean bl = isOffHand = livingEntity.func_184592_cb() == heldStack;
            if (livingEntity.func_184614_ca().func_77973_b() instanceof FishingRodItem) {
                isOffHand = false;
            }
            return (isMainhand || isOffHand) && livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71104_cf != null ? 1.0f : 0.0f;
        });
    }

    public static void registerBowModelProperties(Item bow) {
        ItemModelsProperties.func_239418_a_((Item)bow, (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.func_184607_cu() != stack ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)bow, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }
}

