/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.api.config.FuzzyMode;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ItemComparisonHelper {
    public boolean isEqualItemType(@Nonnull ItemStack that, @Nonnull ItemStack other) {
        return !that.func_190926_b() && !other.func_190926_b() && that.func_77973_b() == other.func_77973_b();
    }

    public boolean isSameItem(@Nonnull ItemStack is, @Nonnull ItemStack filter) {
        return ItemStack.func_179545_c((ItemStack)is, (ItemStack)filter) && this.isNbtTagEqual(is.func_77978_p(), filter.func_77978_p());
    }

    public boolean isFuzzyEqualItem(ItemStack a, ItemStack b, FuzzyMode mode) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b() && a.func_77973_b().func_77645_m()) {
            if (mode == FuzzyMode.IGNORE_ALL) {
                return true;
            }
            if (mode == FuzzyMode.PERCENT_99) {
                return a.func_77952_i() > 1 == b.func_77952_i() > 1;
            }
            float percentDamagedOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
            float percentDamagedOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
            return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
        }
        return a.func_77969_a(b);
    }

    public boolean isNbtTagEqual(CompoundNBT left, CompoundNBT right) {
        boolean isRightEmpty;
        if (left == right) {
            return true;
        }
        boolean isLeftEmpty = left == null || left.isEmpty();
        boolean bl = isRightEmpty = right == null || right.isEmpty();
        if (isLeftEmpty && isRightEmpty) {
            return true;
        }
        if (isLeftEmpty != isRightEmpty) {
            return false;
        }
        if (left != null) {
            return left.equals((Object)right);
        }
        return false;
    }
}

