/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.util.AEPartLocation;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.CraftingTileEntity;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CraftingCPUCalculator
extends MBCalculator<CraftingTileEntity, CraftingCPUCluster> {
    public CraftingCPUCalculator(CraftingTileEntity t) {
        super(t);
    }

    @Override
    public boolean checkMultiblockScale(BlockPos min, BlockPos max) {
        if (max.func_177958_n() - min.func_177958_n() > 16) {
            return false;
        }
        if (max.func_177956_o() - min.func_177956_o() > 16) {
            return false;
        }
        return max.func_177952_p() - min.func_177952_p() <= 16;
    }

    @Override
    public CraftingCPUCluster createCluster(World w, BlockPos min, BlockPos max) {
        return new CraftingCPUCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(World w, BlockPos min, BlockPos max) {
        boolean storage = false;
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            IAEMultiBlock te = (IAEMultiBlock)w.func_175625_s(blockPos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (storage || !(te instanceof CraftingTileEntity)) continue;
            storage = ((CraftingTileEntity)te).getStorageBytes() > 0;
        }
        return storage;
    }

    @Override
    public void updateTiles(CraftingCPUCluster c, World w, BlockPos min, BlockPos max) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            CraftingTileEntity te = (CraftingTileEntity)w.func_175625_s(blockPos);
            te.updateStatus(c);
            c.addTile(te);
        }
        c.done();
        Iterator<CraftingTileEntity> i = c.getTiles();
        while (i.hasNext()) {
            IGrid g;
            IGridHost gh = i.next();
            IGridNode n = gh.getGridNode(AEPartLocation.INTERNAL);
            if (n == null || (g = n.getGrid()) == null) continue;
            g.postEvent(new MENetworkCraftingCpuChange(n));
            return;
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof CraftingTileEntity;
    }
}

