/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.helpers.InvalidPatternHelper;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EncodedPatternItem
extends AEBaseItem {
    public static final String NBT_INGREDIENTS = "in";
    public static final String NBT_PRODUCTS = "out";
    public static final String NBT_SUBSITUTE = "substitute";
    public static final String NBT_RECIPE_ID = "recipe";
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();

    public EncodedPatternItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity player, Hand hand) {
        this.clearPattern(player.func_184586_b(hand), player);
        return new ActionResult(ActionResultType.func_233537_a_((boolean)w.func_201670_d()), (Object)player.func_184586_b(hand));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.clearPattern(stack, context.func_195999_j()) ? ActionResultType.func_233537_a_((boolean)context.func_195991_k().func_201670_d()) : ActionResultType.PASS;
    }

    private boolean clearPattern(ItemStack stack, PlayerEntity player) {
        if (InteractionUtil.isInAlternateUseMode(player)) {
            if (player.func_130014_f_().func_201670_d()) {
                return false;
            }
            PlayerInventory inv = player.field_71071_by;
            ItemStack is = Api.instance().definitions().materials().blankPattern().maybeStack(stack.func_190916_E()).orElse(ItemStack.field_190927_a);
            if (!is.func_190926_b()) {
                for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                    if (inv.func_70301_a(s) != stack) continue;
                    inv.func_70299_a(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        ICraftingPatternDetails details = Api.instance().crafting().decodePattern(stack, world);
        if (details == null) {
            if (!stack.func_77942_o()) {
                return;
            }
            stack.func_200302_a((ITextComponent)GuiText.InvalidPattern.text().func_230532_e_().func_240699_a_(TextFormatting.RED));
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            IFormattableTextComponent label = (invalid.isCraftable() ? GuiText.Crafts.text() : GuiText.Creates.text()).func_230532_e_().func_240702_b_(": ");
            IFormattableTextComponent and = new StringTextComponent(" ").func_230532_e_().func_230529_a_(GuiText.And.text()).func_230532_e_().func_240702_b_(" ");
            IFormattableTextComponent with = GuiText.With.text().func_230532_e_().func_240702_b_(": ");
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((ITextComponent)(first ? label : and).func_230532_e_().func_230529_a_(output.getFormattedToolTip()));
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((ITextComponent)(first ? with : and).func_230532_e_().func_230529_a_(input.getFormattedToolTip()));
                first = false;
            }
            if (invalid.isCraftable()) {
                IFormattableTextComponent substitutionLabel = GuiText.Substitute.text().func_230532_e_().func_240702_b_(" ");
                ITextComponent canSubstitute = invalid.canSubstitute() ? GuiText.Yes.text() : GuiText.No.text();
                lines.add((ITextComponent)substitutionLabel.func_230532_e_().func_230529_a_(canSubstitute));
            }
            return;
        }
        if (stack.func_82837_s()) {
            stack.func_196083_e("display");
        }
        boolean isCrafting = details.isCraftable();
        boolean substitute = details.canSubstitute();
        List<IAEItemStack> in = details.getInputs();
        List<IAEItemStack> out = details.getOutputs();
        IFormattableTextComponent label = (isCrafting ? GuiText.Crafts.text() : GuiText.Creates.text()).func_230532_e_().func_240702_b_(": ");
        IFormattableTextComponent and = new StringTextComponent(" ").func_230532_e_().func_230529_a_(GuiText.And.text()).func_240702_b_(" ");
        IFormattableTextComponent with = GuiText.With.text().func_230532_e_().func_240702_b_(": ");
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((ITextComponent)(first ? label : and).func_230532_e_().func_240702_b_(anOut.getStackSize() + "x ").func_230529_a_(Platform.getItemDisplayName(anOut)));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((ITextComponent)(first ? with : and).func_230532_e_().func_240702_b_(anIn.getStackSize() + "x ").func_230529_a_(Platform.getItemDisplayName(anIn)));
            first = false;
        }
        if (isCrafting) {
            IFormattableTextComponent substitutionLabel = GuiText.Substitute.text().func_230532_e_().func_240702_b_(" ");
            ITextComponent canSubstitute = substitute ? GuiText.Yes.text() : GuiText.No.text();
            lines.add((ITextComponent)substitutionLabel.func_230532_e_().func_230529_a_(canSubstitute));
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        World w = AppEng.proxy.getWorld();
        if (w == null) {
            return ItemStack.field_190927_a;
        }
        ICraftingPatternDetails details = Api.instance().crafting().decodePattern(item, w);
        out = details != null ? details.getOutputs().get(0).createItemStack() : ItemStack.field_190927_a;
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    public boolean isEncodedPattern(ItemStack itemStack) {
        return itemStack != null && !itemStack.func_190926_b() && itemStack.func_77973_b() == this && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_150297_b(NBT_INGREDIENTS, 9) && itemStack.func_77978_p().func_150297_b(NBT_PRODUCTS, 9);
    }

    public ResourceLocation getCraftingRecipeId(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack.func_77973_b() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        CompoundNBT tag = itemStack.func_77978_p();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        return tag.func_150297_b(NBT_RECIPE_ID, 8) ? new ResourceLocation(tag.func_74779_i(NBT_RECIPE_ID)) : null;
    }

    public List<IAEItemStack> getIngredients(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack.func_77973_b() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        CompoundNBT tag = itemStack.func_77978_p();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        ListNBT inTag = tag.func_150295_c(NBT_INGREDIENTS, 10);
        Preconditions.checkArgument((inTag.size() < 10 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>(inTag.size());
        for (int x = 0; x < inTag.size(); ++x) {
            CompoundNBT ingredient = inTag.func_150305_b(x);
            ItemStack gs = ItemStack.func_199557_a((CompoundNBT)ingredient);
            Preconditions.checkArgument((ingredient.isEmpty() || !gs.func_190926_b() ? 1 : 0) != 0, (String)"invalid itemStack in slot", (int)x);
            in.add((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
        }
        return in;
    }

    public List<IAEItemStack> getProducts(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack.func_77973_b() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        CompoundNBT tag = itemStack.func_77978_p();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        ListNBT outTag = tag.func_150295_c(NBT_PRODUCTS, 10);
        Preconditions.checkArgument((outTag.size() < 4 ? 1 : 0) != 0, (Object)"Cannot use more than 3 ingredients");
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>(outTag.size());
        for (int x = 0; x < outTag.size(); ++x) {
            CompoundNBT ingredient = outTag.func_150305_b(x);
            ItemStack gs = ItemStack.func_199557_a((CompoundNBT)ingredient);
            Preconditions.checkArgument((ingredient.isEmpty() || !gs.func_190926_b() ? 1 : 0) != 0, (String)"invalid itemStack in slot", (int)x);
            out.add((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
        }
        return out;
    }

    public boolean allowsSubstitution(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        return this.getCraftingRecipeId(itemStack) != null && tag.func_74767_n(NBT_SUBSITUTE);
    }

    public static void encodeCraftingPattern(ItemStack stack, ItemStack[] in, ItemStack[] out, ResourceLocation recipeId, boolean allowSubstitutes) {
        CompoundNBT encodedValue = EncodedPatternItem.encodeInputsAndOutputs(in, out);
        encodedValue.func_74778_a(NBT_RECIPE_ID, recipeId.toString());
        encodedValue.func_74757_a(NBT_SUBSITUTE, allowSubstitutes);
        stack.func_77982_d(encodedValue);
    }

    public static void encodeProcessingPattern(ItemStack stack, ItemStack[] in, ItemStack[] out) {
        stack.func_77982_d(EncodedPatternItem.encodeInputsAndOutputs(in, out));
    }

    private static CompoundNBT encodeInputsAndOutputs(ItemStack[] in, ItemStack[] out) {
        CompoundNBT encodedValue = new CompoundNBT();
        ListNBT tagIn = new ListNBT();
        ListNBT tagOut = new ListNBT();
        boolean hasInput = false;
        for (ItemStack i : in) {
            tagIn.add((Object)EncodedPatternItem.createItemTag(i));
            if (i.func_190926_b()) continue;
            hasInput = true;
        }
        Preconditions.checkArgument((boolean)hasInput, (Object)"cannot encode a pattern that has no inputs.");
        boolean hasNonEmptyOutput = false;
        for (ItemStack i : out) {
            tagOut.add((Object)EncodedPatternItem.createItemTag(i));
            if (i.func_190926_b()) continue;
            hasNonEmptyOutput = true;
        }
        Preconditions.checkArgument((boolean)hasNonEmptyOutput, (Object)"cannot encode a pattern that has no output.");
        encodedValue.func_218657_a(NBT_INGREDIENTS, (INBT)tagIn);
        encodedValue.func_218657_a(NBT_PRODUCTS, (INBT)tagOut);
        return encodedValue;
    }

    private static INBT createItemTag(ItemStack i) {
        CompoundNBT c = new CompoundNBT();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
        }
        return c;
    }
}

