/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.entity.AEBaseItemEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class ChargedQuartzEntity
extends AEBaseItemEntity {
    private static final Random RANDOM = new Random();
    public static EntityType<ChargedQuartzEntity> TYPE;
    private int delay = 0;
    private int transformTime = 0;

    public ChargedQuartzEntity(EntityType<? extends ChargedQuartzEntity> entityType, World world) {
        super(entityType, world);
    }

    public ChargedQuartzEntity(World w, double x, double y, double z, ItemStack is) {
        super(TYPE, w, x, y, z, is);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L || !AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            return;
        }
        if (this.field_70170_p.func_201670_d() && this.delay > 30 && AEConfig.instance().isEnableEffects()) {
            AppEng.proxy.spawnEffect(EffectType.Lightning, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), null);
            this.delay = 0;
        }
        ++this.delay;
        int j = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int i = MathHelper.func_76128_c((double)((this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0));
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockState state = this.field_70170_p.func_180495_p(new BlockPos(j, i, k));
        Material mat = state.func_185904_a();
        if (!this.field_70170_p.func_201670_d() && mat.func_76224_d()) {
            ++this.transformTime;
            if (this.transformTime > 60 && !this.transform()) {
                this.transformTime = 0;
            }
        } else {
            this.transformTime = 0;
        }
    }

    private boolean transform() {
        ItemStack item = this.func_92059_d();
        IMaterials materials = Api.instance().definitions().materials();
        if (materials.certusQuartzCrystalCharged().isSameAs(item)) {
            AxisAlignedBB region = new AxisAlignedBB(this.func_226277_ct_() - 1.0, this.func_226278_cu_() - 1.0, this.func_226281_cx_() - 1.0, this.func_226277_ct_() + 1.0, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + 1.0);
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            ItemEntity redstone = null;
            ItemEntity netherQuartz = null;
            for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof ItemEntity) || e.field_70128_L || (other = ((ItemEntity)e).func_92059_d()).func_190926_b()) continue;
                if (ItemStack.func_179545_c((ItemStack)other, (ItemStack)new ItemStack((IItemProvider)Items.field_151137_ax))) {
                    redstone = (ItemEntity)e;
                }
                if (!ItemStack.func_179545_c((ItemStack)other, (ItemStack)new ItemStack((IItemProvider)Items.field_151128_bU))) continue;
                netherQuartz = (ItemEntity)e;
            }
            if (redstone != null && netherQuartz != null) {
                this.func_92059_d().func_190917_f(-1);
                redstone.func_92059_d().func_190917_f(-1);
                netherQuartz.func_92059_d().func_190917_f(-1);
                if (this.func_92059_d().func_190916_E() <= 0) {
                    this.func_70106_y();
                }
                if (redstone.func_92059_d().func_190916_E() <= 0) {
                    redstone.func_70106_y();
                }
                if (netherQuartz.func_92059_d().func_190916_E() <= 0) {
                    netherQuartz.func_70106_y();
                }
                materials.fluixCrystal().maybeStack(2).ifPresent(is -> {
                    double x = Math.floor(this.func_226277_ct_()) + 0.25 + RANDOM.nextDouble() * 0.5;
                    double y = Math.floor(this.func_226278_cu_()) + 0.25 + RANDOM.nextDouble() * 0.5;
                    double z = Math.floor(this.func_226281_cx_()) + 0.25 + RANDOM.nextDouble() * 0.5;
                    double xSpeed = RANDOM.nextDouble() * 0.25 - 0.125;
                    double ySpeed = RANDOM.nextDouble() * 0.25 - 0.125;
                    double zSpeed = RANDOM.nextDouble() * 0.25 - 0.125;
                    ItemEntity entity = new ItemEntity(this.field_70170_p, x, y, z, is);
                    entity.func_213293_j(xSpeed, ySpeed, zSpeed);
                    this.field_70170_p.func_217376_c((Entity)entity);
                });
                return true;
            }
        }
        return false;
    }
}

