/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.core.AELog;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EraserItem
extends AEBaseItem {
    private static final int BOX_SIZE = 48;
    private static final int BLOCK_ERASE_LIMIT = 110592;
    static final Set<Block> COMMON_BLOCKS = new HashSet<Block>();

    public EraserItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Block state = world.func_180495_p(pos).func_177230_c();
        boolean bulk = InteractionUtil.isInAlternateUseMode(player);
        ArrayDeque<BlockPos> next = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        Set<Block> commonBlocks = this.getCommonBlocks();
        next.add(pos);
        int blocks = 0;
        while (blocks < 110592 && next.peek() != null) {
            BlockPos wc = (BlockPos)next.poll();
            Block c_state = world.func_180495_p(wc).func_177230_c();
            boolean contains = state == c_state || bulk && commonBlocks.contains(c_state);
            closed.add(wc);
            if (!contains) continue;
            ++blocks;
            world.func_180501_a(wc, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_175655_b(wc, false);
            if (!this.isInsideBox(wc, pos)) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos nextPos;
                        if (0 == x && 0 == y && 0 == z || closed.contains(nextPos = wc.func_177982_a(x, y, z))) continue;
                        next.add(nextPos);
                    }
                }
            }
        }
        AELog.info("Delete " + blocks + " blocks", new Object[0]);
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    private boolean isInsideBox(BlockPos pos, BlockPos origin) {
        boolean ret = true;
        if (pos.func_177958_n() > origin.func_177958_n() + 48 || pos.func_177958_n() < origin.func_177958_n() - 48) {
            ret = false;
        }
        if (pos.func_177956_o() > origin.func_177956_o() + 48 || pos.func_177956_o() < origin.func_177956_o() - 48) {
            ret = false;
        }
        if (pos.func_177952_p() > origin.func_177952_p() + 48 || pos.func_177952_p() < origin.func_177952_p() - 48) {
            ret = false;
        }
        return ret;
    }

    private Set<Block> getCommonBlocks() {
        if (COMMON_BLOCKS.isEmpty()) {
            COMMON_BLOCKS.add(Blocks.field_150348_b);
            COMMON_BLOCKS.add(Blocks.field_150346_d);
            COMMON_BLOCKS.add(Blocks.field_196658_i);
            COMMON_BLOCKS.add(Blocks.field_150347_e);
            COMMON_BLOCKS.add(Blocks.field_196656_g);
            COMMON_BLOCKS.add(Blocks.field_196650_c);
            COMMON_BLOCKS.add(Blocks.field_196654_e);
            COMMON_BLOCKS.add(Blocks.field_150351_n);
            COMMON_BLOCKS.add(Blocks.field_150322_A);
            COMMON_BLOCKS.add(Blocks.field_150424_aL);
            COMMON_BLOCKS.add(Blocks.field_150355_j);
            COMMON_BLOCKS.add(Blocks.field_150353_l);
            COMMON_BLOCKS.addAll(BlockTags.field_206952_E.func_230236_b_());
            COMMON_BLOCKS.addAll(BlockTags.field_203436_u.func_230236_b_());
            COMMON_BLOCKS.addAll(BlockTags.field_200031_h.func_230236_b_());
        }
        return COMMON_BLOCKS;
    }
}

