/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.storage.data.IAEStack;
import appeng.me.cache.CraftingGridCache;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CraftingWatcher
implements ICraftingWatcher {
    private final CraftingGridCache gsc;
    private final ICraftingWatcherHost host;
    private final Set<IAEStack> myInterests = new HashSet<IAEStack>();

    public CraftingWatcher(CraftingGridCache cache, ICraftingWatcherHost host) {
        this.gsc = cache;
        this.host = host;
    }

    public ICraftingWatcherHost getHost() {
        return this.host;
    }

    public boolean add(IAEStack e) {
        if (this.myInterests.contains(e)) {
            return false;
        }
        return this.myInterests.add((IAEStack)e.copy()) && this.gsc.getInterestManager().put(e, this);
    }

    public boolean remove(IAEStack o) {
        return this.myInterests.remove(o) && this.gsc.getInterestManager().remove(o, this);
    }

    @Override
    public void reset() {
        Iterator<IAEStack> i = this.myInterests.iterator();
        while (i.hasNext()) {
            this.gsc.getInterestManager().remove(i.next(), this);
            i.remove();
        }
    }
}

