/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.CompassRequestPacket;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class CompassResponsePacket
extends BasePacket {
    private final long attunement;
    private final int cx;
    private final int cz;
    private final int cdy;
    private CompassResult cr;

    public CompassResponsePacket(PacketBuffer stream) {
        this.attunement = stream.readLong();
        this.cx = stream.readInt();
        this.cz = stream.readInt();
        this.cdy = stream.readInt();
        this.cr = new CompassResult(stream.readBoolean(), stream.readBoolean(), stream.readDouble());
    }

    public CompassResponsePacket(CompassRequestPacket req, boolean hasResult, boolean spin, double radians) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.attunement = req.attunement;
        data.writeLong(this.attunement);
        this.cx = req.cx;
        data.writeInt(this.cx);
        this.cz = req.cz;
        data.writeInt(this.cz);
        this.cdy = req.cdy;
        data.writeInt(this.cdy);
        data.writeBoolean(hasResult);
        data.writeBoolean(spin);
        data.writeDouble(radians);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        CompassManager.INSTANCE.postResult(this.attunement, this.cx << 4, this.cdy << 5, this.cz << 4, this.cr);
    }
}

