/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.events.LocatableEventAnnounce;
import appeng.api.features.ILocatable;
import appeng.api.features.ILocatableRegistry;
import appeng.core.AELog;
import appeng.util.Platform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public final class LocatableRegistry
implements ILocatableRegistry {
    private final Map<Long, ILocatable> set = new HashMap<Long, ILocatable>();

    public LocatableRegistry() {
        MinecraftForge.EVENT_BUS.addListener(this::updateLocatable);
    }

    private void updateLocatable(LocatableEventAnnounce e) {
        TileEntity tileEntity;
        if (e.target instanceof TileEntity ? (tileEntity = (TileEntity)e.target).func_145831_w() == null || tileEntity.func_145831_w().func_201670_d() : Platform.isClient()) {
            return;
        }
        if (e.change == LocatableEventAnnounce.LocatableEvent.REGISTER) {
            AELog.debug("Registering locatable %s: %s", e.target.getLocatableSerial(), e.target);
            this.set.put(e.target.getLocatableSerial(), e.target);
        } else if (e.change == LocatableEventAnnounce.LocatableEvent.UNREGISTER) {
            AELog.debug("Unregistering locatable %s: %s", e.target.getLocatableSerial(), e.target);
            this.set.remove(e.target.getLocatableSerial());
        }
    }

    @Override
    public ILocatable getLocatableBy(long serial) {
        return this.set.get(serial);
    }
}

