/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.storage.data.IAEStack;
import appeng.client.gui.me.common.ClientReadOnlySlot;
import appeng.client.gui.me.common.Repo;
import appeng.container.me.common.GridInventoryEntry;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class RepoSlot<T extends IAEStack<T>>
extends ClientReadOnlySlot {
    private final Repo<T> repo;
    private final int offset;

    public RepoSlot(Repo<T> repo, int offset, int displayX, int displayY) {
        super(displayX, displayY);
        this.repo = repo;
        this.offset = offset;
    }

    public GridInventoryEntry<T> getEntry() {
        if (this.repo.hasPower()) {
            return this.repo.get(this.offset);
        }
        return null;
    }

    public long getStoredAmount() {
        GridInventoryEntry<T> entry = this.getEntry();
        return entry != null ? entry.getStoredAmount() : 0L;
    }

    public long getRequestableAmount() {
        GridInventoryEntry<T> entry = this.getEntry();
        return entry != null ? entry.getRequestableAmount() : 0L;
    }

    public boolean isCraftable() {
        GridInventoryEntry<T> entry = this.getEntry();
        return entry != null && entry.isCraftable();
    }

    public ItemStack func_75211_c() {
        GridInventoryEntry<T> entry = this.getEntry();
        if (entry != null) {
            return entry.getStack().asItemStackRepresentation();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_75216_d() {
        return this.getEntry() != null;
    }

    @Nullable
    public static <T extends IAEStack<T>> RepoSlot<T> tryCast(Repo<T> repo, @Nullable Slot slot) {
        if (slot instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            if (repoSlot.repo == repo) {
                return repoSlot;
            }
        }
        return null;
    }
}

