/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.fluids;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.fluids.FluidSorters;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.util.Platform;
import java.util.Comparator;
import java.util.regex.Pattern;

class FluidRepo
extends Repo<IAEFluidStack> {
    public FluidRepo(IScrollSource src, ISortSource sortSrc) {
        super(src, sortSrc);
    }

    @Override
    protected boolean matchesSearch(Repo.SearchMode searchMode, Pattern searchPattern, IAEFluidStack stack) {
        if (searchMode == Repo.SearchMode.MOD) {
            String modId = Platform.getModId(stack);
            return searchPattern.matcher(modId).find();
        }
        String displayName = Platform.getFluidDisplayName(stack).getString();
        return searchPattern.matcher(displayName).find();
    }

    @Override
    protected Comparator<? super IAEFluidStack> getComparator(SortOrder sortBy, SortDir sortDir) {
        return FluidSorters.getComparator(sortBy, sortDir);
    }
}

