/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public final class Tooltip {
    private final List<ITextComponent> content;

    public Tooltip(List<ITextComponent> unprocessedLines) {
        this.content = new ArrayList<ITextComponent>(unprocessedLines.size());
        for (ITextComponent unprocessedLine : unprocessedLines) {
            Tooltip.splitLine(unprocessedLine, this.content);
        }
    }

    private static void splitLine(ITextComponent unprocessedLine, List<ITextComponent> lines) {
        LineSplittingVisitor visitor = new LineSplittingVisitor(lines);
        unprocessedLine.func_230439_a_((ITextProperties.IStyledTextAcceptor)visitor, Style.field_240709_b_);
        visitor.flush();
    }

    public Tooltip(ITextComponent ... content) {
        this(Arrays.asList(content));
    }

    public List<ITextComponent> getContent() {
        return this.content;
    }

    private static class LineSplittingVisitor
    implements ITextProperties.IStyledTextAcceptor<Object> {
        private final List<ITextComponent> lines;
        private IFormattableTextComponent currentPart;

        public LineSplittingVisitor(List<ITextComponent> lines) {
            this.lines = lines;
        }

        public Optional<Object> accept(Style style, String text) {
            String[] parts = text.split("\n", -1);
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    this.flush();
                }
                String line = parts[i];
                IFormattableTextComponent part = new StringTextComponent(line).func_230530_a_(style);
                this.currentPart = this.currentPart != null ? this.currentPart.func_230529_a_((ITextComponent)part) : part;
            }
            return Optional.empty();
        }

        public void flush() {
            if (this.currentPart != null) {
                if (this.currentPart.func_150256_b() == Style.field_240709_b_) {
                    if (this.lines.isEmpty()) {
                        this.currentPart.func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE));
                    } else {
                        this.currentPart.func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY));
                    }
                }
                this.lines.add((ITextComponent)this.currentPart);
                this.currentPart = null;
            }
        }
    }
}

