/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.bootstrap.FeatureFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityBuilder<T extends Entity> {
    private final FeatureFactory factory;
    private final String id;
    private final EntityType.Builder<T> builder;
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);

    public EntityBuilder(FeatureFactory factory, String id, EntityType.IFactory<T> entityFactory, EntityClassification classification) {
        this.factory = factory;
        this.id = id;
        this.builder = EntityType.Builder.func_220322_a(entityFactory, (EntityClassification)classification);
    }

    public EntityBuilder<T> features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    public EntityBuilder<T> addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    public EntityBuilder<T> customize(Consumer<EntityType.Builder<T>> function) {
        function.accept(this.builder);
        return this;
    }

    public EntityType<T> build() {
        EntityType entityType = this.builder.func_206830_a("appliedenergistics2:" + this.id);
        entityType.setRegistryName("appliedenergistics2", this.id);
        this.factory.addBootstrapComponent(r -> r.register((IForgeRegistryEntry)entityType));
        return entityType;
    }
}

