/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.AEAxisAlignedBB;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.tile.misc.ChargerTileEntity;
import appeng.util.InteractionUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChargerBlock
extends AEBaseTileBlock<ChargerTileEntity> {
    public ChargerBlock() {
        super(ChargerBlock.defaultProps(Material.field_151573_f).func_226896_b_());
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 2;
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        ChargerTileEntity tc;
        if (InteractionUtil.isInAlternateUseMode(player)) {
            return ActionResultType.PASS;
        }
        if (!w.func_201670_d() && (tc = (ChargerTileEntity)this.getTileEntity((IBlockReader)w, pos)) != null) {
            tc.activate(player);
        }
        return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        ChargerTileEntity tile = (ChargerTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tile != null && Api.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(tile.getInternalInventory().getStackInSlot(0))) {
            double xOff = 0.0;
            double yOff = 0.0;
            double zOff = 0.0;
            for (int bolts = 0; bolts < 3; ++bolts) {
                if (!AppEng.proxy.shouldAddParticles(r)) continue;
                Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.LIGHTNING, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        ChargerTileEntity tile = (ChargerTileEntity)this.getTileEntity(w, pos);
        if (tile != null) {
            double twoPixels = 0.125;
            Direction up = tile.getUp();
            Direction forward = tile.getForward();
            AEAxisAlignedBB bb = new AEAxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
            if (up.func_82601_c() != 0) {
                bb.minX = 0.0;
                bb.maxX = 1.0;
            }
            if (up.func_96559_d() != 0) {
                bb.minY = 0.0;
                bb.maxY = 1.0;
            }
            if (up.func_82599_e() != 0) {
                bb.minZ = 0.0;
                bb.maxZ = 1.0;
            }
            switch (forward) {
                case DOWN: {
                    bb.maxY = 1.0;
                    break;
                }
                case UP: {
                    bb.minY = 0.0;
                    break;
                }
                case NORTH: {
                    bb.maxZ = 1.0;
                    break;
                }
                case SOUTH: {
                    bb.minZ = 0.0;
                    break;
                }
                case EAST: {
                    bb.minX = 0.0;
                    break;
                }
                case WEST: {
                    bb.maxX = 1.0;
                    break;
                }
            }
            return VoxelShapes.func_197881_a((AxisAlignedBB)bb.getBoundingBox());
        }
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

