/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.helpers.AEMaterials;
import appeng.util.Platform;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public abstract class AEBaseBlock
extends Block {
    private boolean isInventory = false;

    protected AEBaseBlock(AbstractBlock.Properties props) {
        super(props);
    }

    public static AbstractBlock.Properties defaultProps(Material material) {
        return AEBaseBlock.defaultProps(material, material.func_151565_r());
    }

    public static AbstractBlock.Properties defaultProps(Material material, MaterialColor color) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(2.2f, 11.0f).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200947_a(AEBaseBlock.getDefaultSoundByMaterial(material));
    }

    private static SoundType getDefaultSoundByMaterial(Material mat) {
        if (mat == AEMaterials.GLASS || mat == Material.field_151592_s) {
            return SoundType.field_185853_f;
        }
        if (mat == Material.field_151576_e) {
            return SoundType.field_185851_d;
        }
        if (mat == Material.field_151575_d) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185852_e;
    }

    public boolean func_149740_M(BlockState state) {
        return this.isInventory();
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return 0;
    }

    public boolean rotateAroundFaceAxis(IWorld w, BlockPos pos, Direction face) {
        IOrientable rotatable = this.getOrientable((IBlockReader)w, pos);
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, face);
                return true;
            }
            Direction forward = rotatable.getForward();
            Direction up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, pos, forward = Platform.rotateAround(forward, face), up = Platform.rotateAround(up, face))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return false;
    }

    public final Direction mapRotation(IOrientable ori, Direction dir) {
        Direction forward = ori.getForward();
        Direction up = ori.getUp();
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
        int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
        int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
        Direction west = null;
        for (Direction dx : Direction.values()) {
            if (dx.func_82601_c() != west_x || dx.func_96559_d() != west_y || dx.func_82599_e() != west_z) continue;
            west = dx;
        }
        if (west == null) {
            return dir;
        }
        if (dir == forward) {
            return Direction.SOUTH;
        }
        if (dir == forward.func_176734_d()) {
            return Direction.NORTH;
        }
        if (dir == up) {
            return Direction.UP;
        }
        if (dir == up.func_176734_d()) {
            return Direction.DOWN;
        }
        if (dir == west) {
            return Direction.WEST;
        }
        if (dir == west.func_176734_d()) {
            return Direction.EAST;
        }
        return null;
    }

    public String toString() {
        String regName = this.getRegistryName() != null ? this.getRegistryName().func_110623_a() : "unregistered";
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + regName + "]";
    }

    protected String getUnlocalizedName(ItemStack is) {
        return this.func_149739_a();
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, Direction axis) {
    }

    protected IOrientable getOrientable(IBlockReader w, BlockPos pos) {
        if (this instanceof IOrientableBlock) {
            IOrientableBlock orientable = (IOrientableBlock)((Object)this);
            return orientable.getOrientable(w, pos);
        }
        return null;
    }

    protected boolean isValidOrientation(IWorld w, BlockPos pos, Direction forward, Direction up) {
        return true;
    }

    protected boolean isInventory() {
        return this.isInventory;
    }

    protected void setInventory(boolean isInventory) {
        this.isInventory = isInventory;
    }
}

