/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.core.AppEng;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class EntropyRecipe
implements class_1860<class_1263> {
    public static final class_2960 TYPE_ID = AppEng.makeId("entropy");
    public static final class_3956<EntropyRecipe> TYPE = class_3956.method_17726((String)TYPE_ID.toString());
    private final class_2960 id;
    private final EntropyMode mode;
    @Nullable
    private final class_2248 inputBlock;
    private final List<StateMatcher> inputBlockMatchers;
    @Nullable
    private final class_3611 inputFluid;
    private final List<StateMatcher> inputFluidMatchers;
    @Nullable
    private final class_2248 outputBlock;
    private final List<StateApplier<?>> outputBlockStateAppliers;
    private final boolean outputBlockKeep;
    @Nullable
    private final class_3611 outputFluid;
    private final List<StateApplier<?>> outputFluidStateAppliers;
    private final boolean outputFluidKeep;
    private final List<class_1799> drops;

    public EntropyRecipe(class_2960 id, EntropyMode mode, class_2248 inputBlock, List<StateMatcher> inputBlockMatchers, class_3611 inputFluid, List<StateMatcher> inputFluidMatchers, class_2248 outputBlock, List<StateApplier<?>> outputBlockStateAppliers, boolean outputBlockKeep, class_3611 outputFluid, List<StateApplier<?>> outputFluidStateAppliers, boolean outputFluidKeep, List<class_1799> drops) {
        Preconditions.checkArgument((inputBlock != null || inputFluid != null ? 1 : 0) != 0, (Object)"One of inputBlock or inputFluid must not be null");
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
        this.inputBlock = inputBlock;
        this.inputBlockMatchers = Objects.requireNonNull(inputBlockMatchers, "inputBlockMatchers must be not null");
        this.inputFluid = inputFluid;
        this.inputFluidMatchers = Objects.requireNonNull(inputFluidMatchers, "inputFluidMatchers must be not null");
        this.outputBlock = outputBlock;
        this.outputBlockStateAppliers = Objects.requireNonNull(outputBlockStateAppliers, "outputBlockStateAppliers must be not null");
        this.outputBlockKeep = outputBlockKeep;
        this.outputFluid = outputFluid;
        this.outputFluidStateAppliers = Objects.requireNonNull(outputFluidStateAppliers, "outputFluidStateAppliers must be not null");
        this.outputFluidKeep = outputFluidKeep;
        this.drops = Objects.requireNonNull(drops, "drops must not be null");
    }

    public boolean method_8115(class_1263 inv, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_1263 inv, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return EntropyRecipeSerializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10211();
    }

    public EntropyMode getMode() {
        return this.mode;
    }

    @Nullable
    public class_2248 getInputBlock() {
        return this.inputBlock;
    }

    @Nullable
    public class_3611 getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public class_2248 getOutputBlock() {
        return this.outputBlock;
    }

    public boolean getOutputBlockKeep() {
        return this.outputBlockKeep;
    }

    @Nullable
    public class_2680 getOutputBlockState(class_2680 originalBlockState) {
        if (this.getOutputBlock() == null) {
            return null;
        }
        class_2680 state = this.getOutputBlock().method_9564();
        if (this.outputBlockKeep) {
            for (class_2769 class_27692 : originalBlockState.method_28501()) {
                state = EntropyRecipe.copyProperty(originalBlockState, state, class_27692);
            }
        }
        for (StateApplier stateApplier : this.outputBlockStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    @Nullable
    public class_3611 getOutputFluid() {
        return this.outputFluid;
    }

    public boolean getOutputFluidKeep() {
        return this.outputFluidKeep;
    }

    @Nullable
    public class_3610 getOutputFluidState(class_3610 originalFluidState) {
        if (this.getOutputFluid() == null) {
            return null;
        }
        class_3610 state = this.getOutputFluid().method_15785();
        if (this.outputFluidKeep) {
            for (class_2769 class_27692 : originalFluidState.method_28501()) {
                state = EntropyRecipe.copyProperty(originalFluidState, state, class_27692);
            }
        }
        for (StateApplier stateApplier : this.outputFluidStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    public List<class_1799> getDrops() {
        return this.drops;
    }

    public boolean matches(EntropyMode mode, class_2680 blockState, class_3610 fluidState) {
        if (this.getMode() != mode) {
            return false;
        }
        if (blockState.method_26204() != this.getInputBlock() && this.getInputBlock() != null) {
            return false;
        }
        if (fluidState.method_15772() != this.getInputFluid() && this.getInputFluid() != null) {
            return false;
        }
        boolean isValid = true;
        if (fluidState.method_15772() == this.getInputFluid()) {
            isValid = this.inputFluidMatchers.stream().allMatch(m -> m.matches((class_2688<?, ?>)fluidState));
        }
        return isValid;
    }

    List<StateMatcher> getInputBlockMatchers() {
        return this.inputBlockMatchers;
    }

    List<StateMatcher> getInputFluidMatchers() {
        return this.inputFluidMatchers;
    }

    List<StateApplier<?>> getOutputBlockStateAppliers() {
        return this.outputBlockStateAppliers;
    }

    List<StateApplier<?>> getOutputFluidStateAppliers() {
        return this.outputFluidStateAppliers;
    }

    private static <T extends Comparable<T>, SH extends class_2688<?, SH>> SH copyProperty(SH from, SH to, class_2769<T> property) {
        if (to.method_28498(property)) {
            return (SH)((class_2688)to.method_11657(property, from.method_11654(property)));
        }
        return to;
    }
}

