/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.orientation.IOrientationStrategy;
import appeng.core.definitions.AEItems;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.service.TickManagerService;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class DebugProvider {
    private static final String TAG_NODES = "debugNodes";
    private static final String TAG_NODE_NAME = "nodeName";
    private static final String TAG_TICK_TIME = "tickTime";
    private static final String TAG_TICK_SLEEPING = "tickSleeping";
    private static final String TAG_TICK_ALERTABLE = "tickAlertable";
    private static final String TAG_TICK_AWAKE = "tickAwake";
    private static final String TAG_TICK_QUEUED = "tickQueued";
    private static final String TAG_TICK_CURRENT_RATE = "tickCurrentRate";
    private static final String TAG_TICK_LAST_TICK = "tickLastTick";
    private static final String TAG_NODE_EXPOSED = "exposedSides";

    private DebugProvider() {
    }

    public static void provideBlockEntityBody(class_2586 object, TooltipContext context, TooltipBuilder tooltip) {
        class_1657 player = context.player();
        if (!DebugProvider.isVisible(player)) {
            return;
        }
        DebugProvider.addBlockEntityRotation(object, tooltip);
        DebugProvider.addToTooltip(context.serverData(), tooltip);
    }

    public static void provideBlockEntityData(class_1657 player, class_2586 object, class_2487 serverData) {
        if (object instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnected = (IGridConnectedBlockEntity)object;
            if (DebugProvider.isVisible(player)) {
                DebugProvider.addServerDataMainNode(serverData, gridConnected.getMainNode());
            }
        }
    }

    public static void providePartBody(AEBasePart object, TooltipContext context, TooltipBuilder tooltip) {
        DebugProvider.addToTooltip(context.serverData(), tooltip);
    }

    public static void providePartData(class_1657 player, AEBasePart part, class_2487 serverData) {
        if (DebugProvider.isVisible(player)) {
            DebugProvider.addServerDataMainNode(serverData, part.getMainNode());
            DebugProvider.addServerDataNode(serverData, "External Node", part.getExternalFacingNode());
        }
    }

    private static void addBlockEntityRotation(class_2586 blockEntity, TooltipBuilder tooltip) {
        class_2680 blockState = blockEntity.method_11010();
        IOrientationStrategy strategy = IOrientationStrategy.get(blockState);
        if (!strategy.getProperties().isEmpty()) {
            class_2350 forward = strategy.getFacing(blockState);
            int spin = strategy.getSpin(blockState);
            tooltip.addLine((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" Forward: ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)forward.name())).method_10852((class_2561)class_2561.method_43470((String)" Spin: ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spin))));
        }
    }

    private static void addToTooltip(class_2487 serverData, TooltipBuilder tooltip) {
        class_2499 nodes = serverData.method_10554(TAG_NODES, 10);
        for (class_2520 node : nodes) {
            class_2487 nodeCompound = (class_2487)node;
            if (nodes.size() > 1) {
                String nodeName = ((class_2487)node).method_10558(TAG_NODE_NAME);
                tooltip.addLine((class_2561)class_2561.method_43470((String)nodeName).method_27692(class_124.field_1056));
            }
            DebugProvider.addNodeToTooltip(nodeCompound, tooltip);
        }
    }

    private static void addNodeToTooltip(class_2487 tag, TooltipBuilder tooltip) {
        long[] tickTimes;
        if (tag.method_10573(TAG_TICK_TIME, 12) && (tickTimes = tag.method_10565(TAG_TICK_TIME)).length == 3) {
            long avg = tickTimes[0];
            long max = tickTimes[1];
            long sum = tickTimes[2];
            tooltip.addLine((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Tick Time: ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Avg: ").method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)Platform.formatTimeMeasurement(avg)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" Max: ").method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)Platform.formatTimeMeasurement(max)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" Sum: ").method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)Platform.formatTimeMeasurement(sum)).method_27692(class_124.field_1068)));
        }
        if (tag.method_10545(TAG_TICK_QUEUED)) {
            ArrayList<String> status = new ArrayList<String>();
            if (tag.method_10577(TAG_TICK_SLEEPING)) {
                status.add("Sleeping");
            }
            if (tag.method_10577(TAG_TICK_ALERTABLE)) {
                status.add("Alertable");
            }
            if (tag.method_10577(TAG_TICK_AWAKE)) {
                status.add("Awake");
            }
            if (tag.method_10577(TAG_TICK_QUEUED)) {
                status.add("Queued");
            }
            tooltip.addLine((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Tick Status: ").method_27692(class_124.field_1068)).method_27693(String.join((CharSequence)", ", status)));
            tooltip.addLine((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Tick Rate: ").method_27692(class_124.field_1068)).method_27693(String.valueOf(tag.method_10550(TAG_TICK_CURRENT_RATE))).method_10852((class_2561)class_2561.method_43470((String)" Last: ").method_27692(class_124.field_1068)).method_27693(tag.method_10550(TAG_TICK_LAST_TICK) + " ticks ago"));
        }
        if (tag.method_10573(TAG_NODE_EXPOSED, 3)) {
            int exposedSides = tag.method_10550(TAG_NODE_EXPOSED);
            class_5250 line = class_2561.method_43470((String)"Node Exposed: ").method_27692(class_124.field_1068);
            for (class_2350 value : class_2350.values()) {
                class_5250 sideText = class_2561.method_43470((String)value.name().substring(0, 1));
                if ((exposedSides & 1 << value.ordinal()) == 0) {
                    sideText.method_27692(class_124.field_1080);
                } else {
                    sideText.method_27692(class_124.field_1060);
                }
                line.method_10852((class_2561)sideText);
            }
            tooltip.addLine((class_2561)line);
        }
    }

    private static void addServerDataMainNode(class_2487 tag, IManagedGridNode managedGridNode) {
        DebugProvider.addServerDataNode(tag, "Main Node", managedGridNode.getNode());
    }

    private static void addServerDataNode(class_2487 tag, String name, @Nullable IGridNode node) {
        class_2487 nodeTag = DebugProvider.toServerData(node, name);
        if (nodeTag != null) {
            class_2499 nodes = (class_2499)tag.method_10580(TAG_NODES);
            if (nodes == null) {
                nodes = new class_2499();
                tag.method_10566(TAG_NODES, (class_2520)nodes);
            }
            nodes.add((Object)nodeTag);
        }
    }

    private static class_2487 toServerData(IGridNode node, String name) {
        if (node == null) {
            return null;
        }
        class_2487 tag = new class_2487();
        tag.method_10582(TAG_NODE_NAME, name);
        if (node.getService(IGridTickable.class) != null) {
            TickManagerService tickManager = (TickManagerService)node.getGrid().getTickManager();
            long avg = tickManager.getAverageTime(node);
            long max = tickManager.getMaximumTime(node);
            long sum = tickManager.getOverallTime(node);
            tag.method_10564(TAG_TICK_TIME, new long[]{avg, max, sum});
            TickManagerService.NodeStatus status = tickManager.getStatus(node);
            tag.method_10556(TAG_TICK_SLEEPING, status.sleeping());
            tag.method_10556(TAG_TICK_ALERTABLE, status.alertable());
            tag.method_10556(TAG_TICK_AWAKE, status.awake());
            tag.method_10556(TAG_TICK_QUEUED, status.queued());
            tag.method_10569(TAG_TICK_CURRENT_RATE, status.currentRate());
            tag.method_10544(TAG_TICK_LAST_TICK, status.lastTick());
        }
        if (node instanceof InWorldGridNode) {
            InWorldGridNode inWorldNode = (InWorldGridNode)node;
            int exposedSides = 0;
            for (class_2350 value : class_2350.values()) {
                if (!inWorldNode.isExposedOnSide(value)) continue;
                exposedSides |= 1 << value.ordinal();
            }
            tag.method_10569(TAG_NODE_EXPOSED, exposedSides);
        }
        return tag;
    }

    private static boolean isVisible(class_1657 player) {
        return AEItems.DEBUG_CARD.isSameAs(player.method_5998(class_1268.field_5810)) || AEItems.DEBUG_CARD.isSameAs(player.method_5998(class_1268.field_5808));
    }
}

