/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.items.misc.PaintBallItem;
import appeng.items.parts.ColoredPartItem;
import appeng.items.parts.PartItem;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.MemoryCardItem;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.ColorApplicatorItem;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_326;

public final class InitItemColors {
    private InitItemColors() {
    }

    public static void init(Registry itemColors) {
        itemColors.register(new StaticItemColor(AEColor.TRANSPARENT), new class_1935[]{AEBlocks.CHEST.method_8389()});
        itemColors.register(MemoryCardItem::getTintColor, AEItems.MEMORY_CARD);
        itemColors.register(InitItemColors::getColorApplicatorColor, AEItems.COLOR_APPLICATOR);
        itemColors.register(AbstractPortableCell::getColor, AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL256K);
        itemColors.register(BasicStorageCell::getColor, AEItems.ITEM_CELL_1K, AEItems.FLUID_CELL_1K, AEItems.ITEM_CELL_4K, AEItems.FLUID_CELL_4K, AEItems.ITEM_CELL_16K, AEItems.FLUID_CELL_16K, AEItems.ITEM_CELL_64K, AEItems.FLUID_CELL_64K, AEItems.ITEM_CELL_256K, AEItems.FLUID_CELL_256K);
        for (ItemDefinition<?> definition : AEItems.getItems()) {
            Object item = definition.method_8389();
            if (item instanceof PartItem) {
                AEColor color = AEColor.TRANSPARENT;
                if (item instanceof ColoredPartItem) {
                    color = ((ColoredPartItem)item).getColor();
                }
                itemColors.register(new StaticItemColor(color), new class_1935[]{item});
                continue;
            }
            if (!(item instanceof PaintBallItem)) continue;
            InitItemColors.registerPaintBall(itemColors, (PaintBallItem)((Object)item));
        }
    }

    private static void registerPaintBall(Registry colors, PaintBallItem item) {
        int renderColor;
        AEColor color = item.getColor();
        int colorValue = item.isLumen() ? color.mediumVariant : color.mediumVariant;
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        if (item.isLumen()) {
            float fail = 0.7f;
            int full = 76;
            renderColor = (int)(76.0f + (float)r * 0.7f) << 16 | (int)(76.0f + (float)g * 0.7f) << 8 | (int)(76.0f + (float)b * 0.7f) | 0xFF000000;
        } else {
            renderColor = r << 16 | g << 8 | b | 0xFF000000;
        }
        colors.register((is, tintIndex) -> renderColor, new class_1935[]{item});
    }

    private static int getColorApplicatorColor(class_1799 itemStack, int idx) {
        if (idx == 0) {
            return -1;
        }
        AEColor col = ((ColorApplicatorItem)itemStack.method_7909()).getActiveColor(itemStack);
        if (col == null) {
            return -1;
        }
        return switch (idx) {
            case 1 -> col.blackVariant;
            case 2 -> col.mediumVariant;
            case 3 -> col.whiteVariant;
            default -> -1;
        };
    }

    @FunctionalInterface
    public static interface Registry {
        public void register(class_326 var1, class_1935 ... var2);
    }
}

