/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks.ticking;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

class ServerBlockEntityRepo {
    private final Map<class_1936, Long2ObjectMap<List<FirstTickInfo<?>>>> blockEntities = new Object2ObjectOpenHashMap();

    ServerBlockEntityRepo() {
    }

    void clear() {
        this.blockEntities.clear();
    }

    synchronized <T extends class_2586> void addBlockEntity(T blockEntity, Consumer<? super T> initFunction) {
        class_1937 level = blockEntity.method_10997();
        int x = blockEntity.method_11016().method_10263() >> 4;
        int z = blockEntity.method_11016().method_10260() >> 4;
        long chunkPos = class_1923.method_8331((int)x, (int)z);
        Long2ObjectMap worldQueue = this.blockEntities.computeIfAbsent((class_1936)level, key -> new Long2ObjectOpenHashMap());
        ((List)worldQueue.computeIfAbsent(chunkPos, key -> new ArrayList())).add(new FirstTickInfo<T>(blockEntity, initFunction));
    }

    synchronized void removeLevel(class_1936 level) {
        this.blockEntities.remove(level);
    }

    synchronized void removeChunk(class_1936 level, long chunkPos) {
        Map queue = (Map)this.blockEntities.get(level);
        if (queue != null) {
            queue.remove(chunkPos);
        }
    }

    public Long2ObjectMap<List<FirstTickInfo<?>>> getBlockEntities(class_1936 level) {
        return this.blockEntities.get(level);
    }

    public List<class_2561> getReport() {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        for (Map.Entry<class_1936, Long2ObjectMap<List<FirstTickInfo<?>>>> levelEntry : this.blockEntities.entrySet()) {
            if (levelEntry.getValue().isEmpty()) continue;
            class_1936 level = levelEntry.getKey();
            String levelName = level.toString();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                levelName = serverLevel.method_27983().method_29177().toString();
            }
            result.add((class_2561)class_2561.method_43470((String)levelName).method_27692(class_124.field_1067));
            for (Long2ObjectMap.Entry chunkEntry : levelEntry.getValue().long2ObjectEntrySet()) {
                class_1923 chunkPos = new class_1923(chunkEntry.getLongKey());
                class_5250 line = class_2561.method_43470((String)(chunkPos.field_9181 + "," + chunkPos.field_9180 + ": ")).method_27692(class_124.field_1067).method_27693(Integer.toString(((List)chunkEntry.getValue()).size()));
                result.add((class_2561)line);
            }
        }
        return result;
    }

    record FirstTickInfo<T extends class_2586>(T blockEntity, Consumer<? super T> initFunction) {
        void callInit() {
            this.initFunction.accept(this.blockEntity);
        }
    }
}

