/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

class InvalidPatternHelper {
    private final List<PatternIngredient> outputs = new ArrayList<PatternIngredient>();
    private final List<PatternIngredient> inputs = new ArrayList<PatternIngredient>();
    private final boolean isCrafting;
    private final boolean canSubstitute;

    public InvalidPatternHelper(class_1799 is) {
        int i;
        class_2487 encodedValue = is.method_7969();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        class_2499 inTag = encodedValue.method_10554("in", 10);
        class_2499 outTag = encodedValue.method_10554("out", 10);
        this.isCrafting = encodedValue.method_10577("crafting");
        this.canSubstitute = this.isCrafting && encodedValue.method_10577("substitute");
        for (i = 0; i < outTag.size(); ++i) {
            this.outputs.add(new PatternIngredient(outTag.method_10602(i)));
        }
        for (i = 0; i < inTag.size(); ++i) {
            class_2487 in = inTag.method_10602(i);
            if (in.method_33133()) continue;
            this.inputs.add(new PatternIngredient(in));
        }
    }

    public List<PatternIngredient> getOutputs() {
        return this.outputs;
    }

    public List<PatternIngredient> getInputs() {
        return this.inputs;
    }

    public boolean isCraftable() {
        return this.isCrafting;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public static class PatternIngredient {
        private String id;
        private int count;
        private int damage;
        private class_1799 stack;

        public PatternIngredient(class_2487 tag) {
            this.stack = class_1799.method_7915((class_2487)tag);
            if (this.stack.method_7960()) {
                this.id = tag.method_10558("id");
                this.count = tag.method_10571("Count");
                this.damage = Math.max(0, tag.method_10568("Damage"));
            }
        }

        public boolean isValid() {
            return !this.stack.method_7960();
        }

        public class_2561 getName() {
            return this.isValid() ? this.stack.method_7964() : class_2561.method_43470((String)(this.id + "@" + this.getDamage()));
        }

        public int getDamage() {
            return this.isValid() ? this.stack.method_7919() : this.damage;
        }

        public int getCount() {
            return this.isValid() ? this.stack.method_7947() : this.count;
        }

        public class_1799 getItem() {
            if (!this.isValid()) {
                throw new IllegalArgumentException("There is no valid ItemStack for this PatternIngredient");
            }
            return this.stack;
        }

        public class_2561 getFormattedToolTip() {
            class_5250 result = class_2561.method_43470((String)(this.getCount() + " ")).method_10852(this.getName());
            if (!this.isValid()) {
                result.method_27692(class_124.field_1061);
            }
            return result;
        }
    }
}

