/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class EnumOption<T extends Enum<T>>
extends BaseOption {
    private final T defaultValue;
    private T currentValue;

    public EnumOption(ConfigSection parent, String id, String comment, T defaultValue) {
        super(parent, id, comment);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    public T get() {
        return this.currentValue;
    }

    public void set(T value) {
        Objects.requireNonNull(value);
        if (value == this.currentValue) {
            return;
        }
        this.currentValue = value;
        this.parent.markDirty();
    }

    @Override
    protected JsonElement write() {
        return new JsonPrimitive(((Enum)this.currentValue).name().toLowerCase());
    }

    @Override
    protected void read(JsonElement element) {
        Enum[] enumConstants;
        if (!element.isJsonPrimitive()) {
            throw new ConfigValidationException(this, "Expected a JSON primitive, but found: " + element);
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isString()) {
            throw new ConfigValidationException(this, "Expected a JSON string, but found: " + primitive);
        }
        String enumName = primitive.getAsString();
        for (Enum enumConstant : enumConstants = (Enum[])((Enum)this.defaultValue).getDeclaringClass().getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(enumName)) continue;
            this.currentValue = enumConstant;
            return;
        }
        String allowedValues = Arrays.stream(enumConstants).map(e -> e.name().toLowerCase()).collect(Collectors.joining(", "));
        throw new ConfigValidationException(this, "Expected one of: " + allowedValues);
    }

    @Override
    public boolean isDifferentFromDefault() {
        return this.currentValue != this.defaultValue;
    }

    @Override
    public String getDefaultAsString() {
        return String.valueOf(((Enum)this.defaultValue).name().toLowerCase());
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(((Enum)this.currentValue).name().toLowerCase());
    }
}

