/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytVisitor;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.style.Styleable;
import appeng.client.guidebook.style.TextStyle;
import appeng.libs.mdast.model.MdAstNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class LytNode
implements Styleable {
    @Nullable
    protected LytNode parent;
    private TextStyle style = TextStyle.EMPTY;
    private TextStyle hoverStyle = TextStyle.EMPTY;
    @Nullable
    private MdAstNode sourceNode;

    public void removeChild(LytNode node) {
    }

    public List<? extends LytNode> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    public LytDocument getDocument() {
        LytNode current = this;
        do {
            if (!(current instanceof LytDocument)) continue;
            LytDocument document = (LytDocument)current;
            return document;
        } while ((current = current.parent) != null);
        return null;
    }

    @Nullable
    public final LytNode getParent() {
        return this.parent;
    }

    public abstract LytRect getBounds();

    public void onMouseEnter(@Nullable LytFlowContent hoveredContent) {
    }

    public void onMouseLeave() {
    }

    public void tick() {
    }

    @Nullable
    public LytNode pickNode(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return null;
        }
        for (LytNode lytNode : this.getChildren()) {
            LytNode node = lytNode.pickNode(x, y);
            if (node == null) continue;
            return node;
        }
        return this;
    }

    public final String getTextContent() {
        var visitor = new LytVisitor(){
            final StringBuilder builder = new StringBuilder();

            @Override
            public void text(String text) {
                this.builder.append(text);
            }
        };
        this.visit(visitor);
        return visitor.builder.toString();
    }

    public final LytVisitor.Result visit(LytVisitor visitor) {
        return this.visit(visitor, false);
    }

    public final LytVisitor.Result visit(LytVisitor visitor, boolean includeOutOfTreeContent) {
        LytVisitor.Result result = visitor.beforeNode(this);
        if (result == LytVisitor.Result.STOP) {
            return result;
        }
        if (result != LytVisitor.Result.SKIP_CHILDREN && this.visitChildren(visitor, includeOutOfTreeContent) == LytVisitor.Result.STOP) {
            return LytVisitor.Result.STOP;
        }
        return visitor.afterNode(this);
    }

    protected LytVisitor.Result visitChildren(LytVisitor visitor, boolean includeOutOfTreeContent) {
        for (LytNode lytNode : this.getChildren()) {
            if (lytNode.visit(visitor, includeOutOfTreeContent) != LytVisitor.Result.STOP) continue;
            return LytVisitor.Result.STOP;
        }
        return LytVisitor.Result.CONTINUE;
    }

    @Override
    public TextStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(TextStyle style) {
        this.style = style;
    }

    @Override
    public TextStyle getHoverStyle() {
        return this.hoverStyle;
    }

    @Override
    public void setHoverStyle(TextStyle style) {
        this.hoverStyle = style;
    }

    @Override
    @Nullable
    public Styleable getStylingParent() {
        return this.parent;
    }

    @Nullable
    public MdAstNode getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(@Nullable MdAstNode sourceNode) {
        this.sourceNode = sourceNode;
    }
}

