/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document;

import appeng.client.guidebook.document.LytPoint;
import appeng.client.guidebook.document.LytSize;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public record LytRect(int x, int y, int width, int height) {
    private static final LytRect EMPTY = new LytRect(0, 0, 0, 0);

    public static LytRect empty() {
        return EMPTY;
    }

    public int right() {
        return this.x + this.width;
    }

    public int bottom() {
        return this.y + this.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public LytRect shrink(int left, int top, int right, int bottom) {
        return new LytRect(this.x + left, this.y + top, Math.max(this.width - left - right, 0), Math.max(this.height - top - bottom, 0));
    }

    public LytRect expand(int amount) {
        return this.expand(amount, amount, amount, amount);
    }

    public LytRect expand(int left, int top, int right, int bottom) {
        return new LytRect(this.x - left, this.y - top, Math.max(this.width + left + right, 0), Math.max(this.height + top + bottom, 0));
    }

    public LytRect withWidth(int width) {
        return new LytRect(this.x, this.y, width, this.height);
    }

    public LytRect withHeight(int height) {
        return new LytRect(this.x, this.y, this.width, height);
    }

    public LytRect move(int x, int y) {
        return new LytRect(this.x + x, this.y + y, this.width, this.height);
    }

    public LytRect centerVerticallyIn(LytRect other) {
        int centerYOther = other.y + other.height / 2;
        return new LytRect(this.x, centerYOther - this.height / 2, this.width, this.height);
    }

    public static LytRect union(LytRect a, LytRect b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        int x = Math.min(a.x, b.x);
        int y = Math.min(a.y, b.y);
        int right = Math.max(a.right(), b.right());
        int bottom = Math.max(a.bottom(), b.bottom());
        return new LytRect(x, y, right - x, bottom - y);
    }

    public boolean contains(LytPoint point) {
        return point.x() >= (float)this.x && point.x() < (float)this.right() && point.y() >= (float)this.y && point.y() < (float)this.bottom();
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.right() && y >= this.y && y < this.bottom();
    }

    public boolean intersects(LytRect other) {
        return this.right() > other.x() && this.x < other.right() && this.bottom() > other.y && this.y < other.bottom();
    }

    public LytRect withX(int x) {
        return new LytRect(x, this.y, this.width, this.height);
    }

    public LytRect withY(int y) {
        return new LytRect(this.x, y, this.width, this.height);
    }

    public LytRect transform(Matrix4f pose) {
        Vector3f tmp = new Vector3f();
        pose.transformPosition((float)this.x, (float)this.y, 0.0f, tmp);
        int left = (int)tmp.x;
        int top = (int)tmp.y;
        return new LytRect(left, top, this.width, this.height);
    }

    public LytSize size() {
        return new LytSize(this.width, this.height);
    }

    public Vector2i point() {
        return new Vector2i(this.x, this.y);
    }
}

