/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook;

import appeng.client.guidebook.GuidePageChange;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.shaded.methvin.watcher.DirectoryChangeEvent;
import appeng.shaded.methvin.watcher.DirectoryChangeListener;
import appeng.shaded.methvin.watcher.DirectoryWatcher;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuideSourceWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuideSourceWatcher.class);
    private final String namespace;
    private final Path sourceFolder;
    @Nullable
    private final DirectoryWatcher sourceWatcher;
    private final Map<class_2960, ParsedGuidePage> changedPages = new HashMap<class_2960, ParsedGuidePage>();
    private final Set<class_2960> deletedPages = new HashSet<class_2960>();
    private final ExecutorService watchExecutor;

    public GuideSourceWatcher(String namespace, Path sourceFolder) {
        DirectoryWatcher watcher;
        this.namespace = namespace;
        this.sourceFolder = sourceFolder;
        if (!Files.isDirectory(sourceFolder, new LinkOption[0])) {
            throw new RuntimeException("Cannot find the specified folder for the AE2 guidebook sources: " + sourceFolder);
        }
        LOGGER.info("Watching guidebook sources in {}", (Object)sourceFolder);
        this.watchExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AE2GuidebookWatcher%d").build());
        try {
            watcher = DirectoryWatcher.builder().path(sourceFolder).fileHashing(false).listener(new Listener()).build();
        }
        catch (IOException e) {
            LOGGER.error("Failed to watch for changes in the guidebook sources at {}", (Object)sourceFolder, (Object)e);
            watcher = null;
        }
        this.sourceWatcher = watcher;
        if (this.sourceWatcher != null) {
            this.sourceWatcher.watchAsync(this.watchExecutor);
        }
    }

    public List<ParsedGuidePage> loadAll() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        final HashMap pagesToLoad = new HashMap();
        try {
            Files.walkFileTree(this.sourceFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    class_2960 pageId = GuideSourceWatcher.this.getPageId(file);
                    if (pageId != null) {
                        pagesToLoad.put(pageId, file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOGGER.error("Failed to list page {}", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        LOGGER.error("Failed to list all pages in {}", (Object)dir, (Object)exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to list all pages in {}", (Object)this.sourceFolder, (Object)e);
        }
        LOGGER.info("Loading {} guidebook pages", (Object)pagesToLoad.size());
        List<ParsedGuidePage> loadedPages = pagesToLoad.entrySet().stream().map(entry -> {
            ParsedGuidePage parsedGuidePage;
            block8: {
                Path path = (Path)entry.getValue();
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                try {
                    parsedGuidePage = PageCompiler.parse("ae2", (class_2960)entry.getKey(), in);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to reload guidebook page {}", (Object)path, (Object)e);
                        return null;
                    }
                }
                in.close();
            }
            return parsedGuidePage;
        }).filter(Objects::nonNull).toList();
        LOGGER.info("Loaded {} pages from {} in {}", new Object[]{loadedPages.size(), this.sourceFolder, stopwatch});
        return loadedPages;
    }

    public synchronized List<GuidePageChange> takeChanges() {
        if (this.deletedPages.isEmpty() && this.changedPages.isEmpty()) {
            return List.of();
        }
        ArrayList<GuidePageChange> changes = new ArrayList<GuidePageChange>();
        for (class_2960 deletedPage : this.deletedPages) {
            changes.add(new GuidePageChange(deletedPage, null, null));
        }
        this.deletedPages.clear();
        for (ParsedGuidePage changedPage : this.changedPages.values()) {
            changes.add(new GuidePageChange(changedPage.getId(), null, changedPage));
        }
        this.changedPages.clear();
        return changes;
    }

    public synchronized void close() {
        this.changedPages.clear();
        this.deletedPages.clear();
        this.watchExecutor.shutdown();
        if (this.sourceWatcher != null) {
            try {
                this.sourceWatcher.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close fileystem watcher for {}", (Object)this.sourceFolder);
            }
        }
    }

    private synchronized void pageChanged(Path path) {
        class_2960 pageId = this.getPageId(path);
        if (pageId == null) {
            return;
        }
        this.deletedPages.remove(pageId);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            ParsedGuidePage page = PageCompiler.parse("ae2", pageId, in);
            this.changedPages.put(pageId, page);
        }
        catch (Exception e) {
            LOGGER.error("Failed to reload guidebook page {}", (Object)path, (Object)e);
        }
    }

    private synchronized void pageDeleted(Path path) {
        class_2960 pageId = this.getPageId(path);
        if (pageId == null) {
            return;
        }
        this.changedPages.remove(pageId);
        this.deletedPages.add(pageId);
    }

    @Nullable
    private class_2960 getPageId(Path path) {
        Path relativePath = this.sourceFolder.relativize(path);
        String relativePathStr = relativePath.toString().replace('\\', '/');
        if (!relativePathStr.endsWith(".md")) {
            return null;
        }
        if (!class_2960.method_20207((String)relativePathStr)) {
            return null;
        }
        return new class_2960(this.namespace, relativePathStr);
    }

    private class Listener
    implements DirectoryChangeListener {
        private Listener() {
        }

        @Override
        public void onEvent(DirectoryChangeEvent event) {
            if (event.isDirectory()) {
                return;
            }
            switch (event.eventType()) {
                case CREATE: 
                case MODIFY: {
                    GuideSourceWatcher.this.pageChanged(event.path());
                    break;
                }
                case DELETE: {
                    GuideSourceWatcher.this.pageDeleted(event.path());
                }
            }
        }

        @Override
        public boolean isWatching() {
            return GuideSourceWatcher.this.sourceWatcher != null && !GuideSourceWatcher.this.sourceWatcher.isClosed();
        }

        @Override
        public void onException(Exception e) {
            LOGGER.error("Failed watching for changes", (Throwable)e);
        }
    }
}

