/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook;

import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.GuidePageChange;
import appeng.client.guidebook.GuideSourceWatcher;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.extensions.DefaultExtensions;
import appeng.client.guidebook.extensions.Extension;
import appeng.client.guidebook.extensions.ExtensionCollection;
import appeng.client.guidebook.extensions.ExtensionPoint;
import appeng.client.guidebook.indices.CategoryIndex;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.indices.PageIndex;
import appeng.client.guidebook.navigation.NavigationTree;
import appeng.client.guidebook.screen.GlobalInMemoryHistory;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.util.Platform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.minecraft.class_156;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4071;
import net.minecraft.class_4080;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_6861;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7780;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Guide
implements PageCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Guide.class);
    private final String defaultNamespace;
    private final String folder;
    private final Map<class_2960, ParsedGuidePage> developmentPages = new HashMap<class_2960, ParsedGuidePage>();
    private final Map<Class<?>, PageIndex> indices;
    private NavigationTree navigationTree = new NavigationTree();
    private Map<class_2960, ParsedGuidePage> pages;
    private final ExtensionCollection extensions;
    @Nullable
    private final Path developmentSourceFolder;
    @Nullable
    private final String developmentSourceNamespace;

    private Guide(String defaultNamespace, String folder, @Nullable Path developmentSourceFolder, @Nullable String developmentSourceNamespace, Map<Class<?>, PageIndex> indices, ExtensionCollection extensions) {
        this.defaultNamespace = defaultNamespace;
        this.folder = folder;
        this.developmentSourceFolder = developmentSourceFolder;
        this.developmentSourceNamespace = developmentSourceNamespace;
        this.indices = indices;
        this.extensions = extensions;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public <T extends PageIndex> T getIndex(Class<T> indexClass) {
        PageIndex index = this.indices.get(indexClass);
        if (index == null) {
            throw new IllegalArgumentException("No index of type " + indexClass + " is registered with this guide.");
        }
        return (T)((PageIndex)indexClass.cast(index));
    }

    public static Builder builder(String defaultNamespace, String folder) {
        return new Builder(defaultNamespace, folder);
    }

    private static CompletableFuture<class_310> afterClientStart() {
        CompletableFuture<class_310> future = new CompletableFuture<class_310>();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            CompletableFuture reload;
            class_4071 patt4779$temp = client.method_18506();
            if (patt4779$temp instanceof class_425) {
                class_425 loadingOverlay = (class_425)patt4779$temp;
                reload = loadingOverlay.field_17767.method_18364();
            } else {
                reload = CompletableFuture.completedFuture(null);
            }
            reload.whenCompleteAsync((o, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(client);
                }
            }, (Executor)client);
        });
        return future;
    }

    public static void runDatapackReload() {
        try {
            class_7780 layeredAccess = class_7659.method_45139();
            class_3283 packRepository = new class_3283(new class_3285[]{new class_3286(), new ModResourcePackCreator(class_3264.field_14190)});
            packRepository.method_14445();
            packRepository.method_14447((Collection)ModResourcePackUtil.createDefaultDataConfiguration().comp_1010().method_29547());
            class_6861 resourceManager = new class_6861(class_3264.field_14190, packRepository.method_29211());
            class_5455.class_6890 worldgenLayer = class_7655.method_45121((class_3300)resourceManager, (class_5455)layeredAccess.method_45935((Object)class_7659.field_39972), (List)class_7655.field_39968);
            layeredAccess = layeredAccess.method_45930((Object)class_7659.field_39972, new class_5455.class_6890[]{worldgenLayer});
            class_5350 stuff = (class_5350)class_5350.method_29466((class_3300)resourceManager, (class_5455.class_6890)layeredAccess.method_45935((Object)class_7659.field_39974), (class_7699)class_7699.method_45397(), (class_2170.class_5364)class_2170.class_5364.field_25419, (int)0, (Executor)class_156.method_18349(), Runnable::run).get();
            stuff.method_40421((class_5455)layeredAccess.method_45926());
            Platform.fallbackClientRecipeManager = stuff.method_29471();
            Platform.fallbackClientRegistryAccess = layeredAccess.method_45926();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public ParsedGuidePage getParsedPage(class_2960 id) {
        if (this.pages == null) {
            LOGGER.warn("Can't get page {}. Pages not loaded yet.", (Object)id);
            return null;
        }
        return this.developmentPages.getOrDefault(id, this.pages.get(id));
    }

    @Override
    @Nullable
    public GuidePage getPage(class_2960 id) {
        ParsedGuidePage page = this.getParsedPage(id);
        return page != null ? PageCompiler.compile(this, this.extensions, page) : null;
    }

    public Collection<ParsedGuidePage> getPages() {
        if (this.pages == null) {
            throw new IllegalStateException("Pages are not loaded yet.");
        }
        HashMap<class_2960, ParsedGuidePage> pages = new HashMap<class_2960, ParsedGuidePage>(this.pages);
        pages.putAll(this.developmentPages);
        return pages.values();
    }

    @Override
    public byte[] loadAsset(class_2960 id) {
        byte[] byArray;
        block21: {
            block20: {
                if (this.developmentSourceFolder != null && id.method_12836().equals(this.developmentSourceNamespace)) {
                    byte[] byArray2;
                    block19: {
                        Path path = this.developmentSourceFolder.resolve(id.method_12832());
                        InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                        try {
                            byArray2 = in2.readAllBytes();
                            if (in2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in2 != null) {
                                    try {
                                        in2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (FileNotFoundException in2) {
                                break block20;
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to open guidebook asset {}", (Object)path);
                                return null;
                            }
                        }
                        in2.close();
                    }
                    return byArray2;
                }
            }
            id = new class_2960(id.method_12836(), this.folder + "/" + id.method_12832());
            class_3298 resource = class_310.method_1551().method_1478().method_14486(id).orElse(null);
            if (resource == null) {
                return null;
            }
            InputStream input = resource.method_14482();
            try {
                byArray = input.readAllBytes();
                if (input == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to open guidebook asset {}", (Object)id);
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public NavigationTree getNavigationTree() {
        return this.navigationTree;
    }

    @Override
    public boolean pageExists(class_2960 pageId) {
        return this.developmentPages.containsKey(pageId) || this.pages != null && this.pages.containsKey(pageId);
    }

    @Nullable
    public Path getDevelopmentSourcePath(class_2960 id) {
        Path path;
        if (this.developmentSourceFolder != null && id.method_12836().equals(this.developmentSourceNamespace) && Files.exists(path = this.developmentSourceFolder.resolve(id.method_12832()), new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public ExtensionCollection getExtensions() {
        return this.extensions;
    }

    private void watchDevelopmentSources() {
        GuideSourceWatcher watcher = new GuideSourceWatcher(this.developmentSourceNamespace, this.developmentSourceFolder);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            List<GuidePageChange> changes = watcher.takeChanges();
            if (!changes.isEmpty()) {
                this.applyChanges(changes);
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> watcher.close());
        for (ParsedGuidePage page : watcher.loadAll()) {
            this.developmentPages.put(page.getId(), page);
        }
    }

    private void applyChanges(List<GuidePageChange> changes) {
        PageIndex index2;
        for (int i = 0; i < changes.size(); ++i) {
            GuidePageChange change = changes.get(i);
            class_2960 pageId = change.pageId();
            ParsedGuidePage oldPage = change.newPage() != null ? this.developmentPages.put(pageId, change.newPage()) : this.developmentPages.remove(pageId);
            changes.set(i, new GuidePageChange(pageId, oldPage, change.newPage()));
        }
        ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>(this.pages.size() + this.developmentPages.size());
        allPages.addAll(this.pages.values());
        allPages.addAll(this.developmentPages.values());
        for (PageIndex index2 : this.indices.values()) {
            if (index2.supportsUpdate()) {
                index2.update(allPages, changes);
                continue;
            }
            index2.rebuild(allPages);
        }
        this.navigationTree = this.buildNavigation();
        index2 = class_310.method_1551().field_1755;
        if (index2 instanceof GuideScreen) {
            GuideScreen guideScreen = (GuideScreen)((Object)index2);
            class_2960 currentPageId = guideScreen.getCurrentPageId();
            if (changes.stream().anyMatch(c -> c.pageId().equals((Object)currentPageId))) {
                guideScreen.reloadPage();
            }
        }
    }

    private NavigationTree buildNavigation() {
        if (this.developmentPages.isEmpty()) {
            return NavigationTree.build(this.pages.values());
        }
        HashMap<class_2960, ParsedGuidePage> allPages = new HashMap<class_2960, ParsedGuidePage>(this.pages);
        allPages.putAll(this.developmentPages);
        return NavigationTree.build(allPages.values());
    }

    private void validateAll() {
        for (Map.Entry<class_2960, ParsedGuidePage> entry : this.developmentPages.entrySet()) {
            LOGGER.info("Compiling {}", (Object)entry.getKey());
            this.getPage(entry.getKey());
        }
    }

    private void registerReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener(new class_2960(this.defaultNamespace, this.folder)));
    }

    public static class Builder {
        private final String defaultNamespace;
        private final String folder;
        private final Map<Class<?>, PageIndex> indices = new IdentityHashMap();
        private final ExtensionCollection.Builder extensionsBuilder = ExtensionCollection.builder();
        private boolean registerReloadListener = true;
        @Nullable
        private class_2960 startupPage;
        private boolean validateAtStartup;
        private Path developmentSourceFolder;
        private String developmentSourceNamespace;
        private boolean watchDevelopmentSources = true;
        private boolean disableDefaultExtensions = false;
        private final Set<ExtensionPoint<?>> disableDefaultsForExtensionPoints = Collections.newSetFromMap(new IdentityHashMap());

        private Builder(String defaultNamespace, String folder) {
            this.defaultNamespace = Objects.requireNonNull(defaultNamespace, "defaultNamespace");
            this.folder = Objects.requireNonNull(folder, folder);
            if (!class_2960.method_20207((String)(defaultNamespace + ":dummy"))) {
                throw new IllegalArgumentException("The default namespace for a guide needs to be a valid namespace");
            }
            if (!class_2960.method_20207((String)("dummy:" + folder))) {
                throw new IllegalArgumentException("The folder for a guide needs to be a valid resource location");
            }
            String startupPageProperty = String.format(Locale.ROOT, "guideDev.%s.startupPage", folder);
            try {
                String startupPageIdText = System.getProperty(startupPageProperty);
                if (startupPageIdText != null) {
                    this.startupPage = new class_2960(startupPageIdText);
                }
            }
            catch (Exception e) {
                LOGGER.error("Specified invalid page id in system property {}", (Object)startupPageProperty);
            }
            String devSourcesFolderProperty = String.format(Locale.ROOT, "guideDev.%s.sources", folder);
            String devSourcesNamespaceProperty = String.format(Locale.ROOT, "guideDev.%s.sourcesNamespace", defaultNamespace);
            String sourceFolder = System.getProperty(devSourcesFolderProperty);
            if (sourceFolder != null) {
                this.developmentSourceFolder = Paths.get(sourceFolder, new String[0]);
                this.developmentSourceNamespace = System.getProperty(devSourcesNamespaceProperty, defaultNamespace);
            }
            this.index(new ItemIndex());
            this.index(new CategoryIndex());
        }

        public Builder registerReloadListener(boolean enable) {
            this.registerReloadListener = enable;
            return this;
        }

        public Builder disableDefaultExtensions() {
            this.disableDefaultExtensions = true;
            return this;
        }

        public Builder disableDefaultExtensions(ExtensionPoint<?> extensionPoint) {
            this.disableDefaultsForExtensionPoints.add(extensionPoint);
            return this;
        }

        public Builder startupPage(@Nullable class_2960 pageId) {
            this.startupPage = pageId;
            return this;
        }

        public Builder validateAllAtStartup(boolean enable) {
            this.validateAtStartup = enable;
            return this;
        }

        public Builder developmentSources(@Nullable Path folder) {
            return this.developmentSources(folder, this.defaultNamespace);
        }

        public Builder developmentSources(Path folder, String namespace) {
            this.developmentSourceFolder = folder;
            this.developmentSourceNamespace = namespace;
            return this;
        }

        public Builder watchDevelopmentSources(boolean enable) {
            this.watchDevelopmentSources = enable;
            return this;
        }

        public Builder index(PageIndex index) {
            this.indices.put(index.getClass(), index);
            return this;
        }

        public <T extends PageIndex> Builder index(Class<? super T> clazz, T index) {
            this.indices.put(clazz, index);
            return this;
        }

        public <T extends Extension> Builder extension(ExtensionPoint<T> extensionPoint, T extension) {
            this.extensionsBuilder.add(extensionPoint, extension);
            return this;
        }

        public Guide build() {
            ExtensionCollection extensionCollection = this.buildExtensions();
            Guide guide = new Guide(this.defaultNamespace, this.folder, this.developmentSourceFolder, this.developmentSourceNamespace, this.indices, extensionCollection);
            if (this.registerReloadListener) {
                guide.registerReloadListener();
            }
            if (this.developmentSourceFolder != null && this.watchDevelopmentSources) {
                guide.watchDevelopmentSources();
            }
            if (this.validateAtStartup || this.startupPage != null) {
                CompletionStage reloadFuture = Guide.afterClientStart().thenRun(Guide::runDatapackReload);
                if (this.validateAtStartup) {
                    reloadFuture = ((CompletableFuture)reloadFuture).thenRun(guide::validateAll);
                }
                if (this.startupPage != null) {
                    reloadFuture = ((CompletableFuture)reloadFuture).thenRun(() -> {
                        class_310 client = class_310.method_1551();
                        client.method_1507((class_437)GuideScreen.openNew(guide, PageAnchor.page(this.startupPage), GlobalInMemoryHistory.INSTANCE));
                    });
                }
                ((CompletableFuture)reloadFuture).whenComplete((unused, throwable) -> {
                    if (throwable != null) {
                        LOGGER.error("Failed Guide startup.", throwable);
                    }
                });
            }
            return guide;
        }

        private ExtensionCollection buildExtensions() {
            ExtensionCollection.Builder builder = ExtensionCollection.builder();
            if (!this.disableDefaultExtensions) {
                DefaultExtensions.addAll(builder, this.disableDefaultsForExtensionPoints);
            }
            builder.addAll(this.extensionsBuilder);
            return builder.build();
        }
    }

    private class ReloadListener
    extends class_4080<Map<class_2960, ParsedGuidePage>>
    implements IdentifiableResourceReloadListener {
        private final class_2960 id;

        public ReloadListener(class_2960 id) {
            this.id = id;
        }

        public class_2960 getFabricId() {
            return this.id;
        }

        protected Map<class_2960, ParsedGuidePage> prepare(class_3300 resourceManager, class_3695 profiler) {
            profiler.method_16065();
            HashMap<class_2960, ParsedGuidePage> pages = new HashMap<class_2960, ParsedGuidePage>();
            Map resources = resourceManager.method_14488(Guide.this.folder, location -> location.method_12832().endsWith(".md"));
            for (Map.Entry entry : resources.entrySet()) {
                class_2960 pageId = new class_2960(((class_2960)entry.getKey()).method_12836(), ((class_2960)entry.getKey()).method_12832().substring((Guide.this.folder + "/").length()));
                String sourcePackId = ((class_3298)entry.getValue()).method_14480();
                try {
                    InputStream in = ((class_3298)entry.getValue()).method_14482();
                    try {
                        pages.put(pageId, PageCompiler.parse(sourcePackId, pageId, in));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load guidebook page {} from pack {}", new Object[]{pageId, sourcePackId, e});
                }
            }
            profiler.method_16066();
            return pages;
        }

        protected void apply(Map<class_2960, ParsedGuidePage> pages, class_3300 resourceManager, class_3695 profiler) {
            profiler.method_16065();
            Guide.this.pages = pages;
            profiler.method_15396("indices");
            ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>();
            allPages.addAll(pages.values());
            allPages.addAll(Guide.this.developmentPages.values());
            for (PageIndex index : Guide.this.indices.values()) {
                index.rebuild(allPages);
            }
            profiler.method_15407();
            profiler.method_15396("navigation");
            Guide.this.navigationTree = Guide.this.buildNavigation();
            profiler.method_15407();
            profiler.method_16066();
        }

        public String method_22322() {
            return this.id.toString();
        }
    }
}

