/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.CellWorkbenchMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;

public class CellWorkbenchScreen
extends UpgradeableScreen<CellWorkbenchMenu> {
    private final ToggleButton copyMode;
    private final SettingToggleButton<FuzzyMode> fuzzyMode = this.addToLeftToolbar(new SettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL, this::toggleFuzzyMode));

    public CellWorkbenchScreen(CellWorkbenchMenu menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.addToLeftToolbar(new ActionButton(ActionItems.WRENCH, act -> menu.partition()));
        this.addToLeftToolbar(new ActionButton(ActionItems.CLOSE, act -> menu.clear()));
        this.copyMode = this.addToLeftToolbar(new ToggleButton(Icon.COPY_MODE_ON, Icon.COPY_MODE_OFF, (class_2561)GuiText.CopyMode.text(), (class_2561)GuiText.CopyModeDesc.text(), act -> menu.nextWorkBenchCopyMode()));
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.copyMode.setState(((CellWorkbenchMenu)this.field_2797).getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        boolean hasFuzzy = ((CellWorkbenchMenu)this.field_2797).getUpgrades().isInstalled(AEItems.FUZZY_CARD);
        this.fuzzyMode.set(((CellWorkbenchMenu)this.field_2797).getFuzzyMode());
        this.fuzzyMode.setVisibility(hasFuzzy);
    }

    private void toggleFuzzyMode(SettingToggleButton<FuzzyMode> button, boolean backwards) {
        FuzzyMode fz = button.getNextValue(backwards);
        ((CellWorkbenchMenu)this.field_2797).setCellFuzzyMode(fz);
    }
}

