/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.spatial;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.events.GridSpatialEvent;
import appeng.api.networking.spatial.ISpatialService;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.util.ILevelRunnable;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpatialIOPortBlockEntity
extends AENetworkInvBlockEntity {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    private final InternalInventory invExt = new FilteredInternalInventory(this.inv, new SpatialIOFilter());
    private YesNo lastRedstoneState = YesNo.UNDECIDED;
    private final ILevelRunnable transitionCallback = level -> this.transition();
    private boolean isActive = false;

    public SpatialIOPortBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("lastRedstoneState", this.lastRedstoneState.ordinal());
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        if (data.method_10545("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.method_10550("lastRedstoneState")];
        }
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean ret = super.readFromStream(data);
        boolean isActive = data.readBoolean();
        ret = isActive != this.isActive || ret;
        this.isActive = isActive;
        return ret;
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_11863.method_49804(this.field_11867) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            if (this.lastRedstoneState == YesNo.YES) {
                this.triggerTransition();
            }
        }
    }

    public boolean isActive() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            return this.getMainNode().isOnline();
        }
        return this.isActive;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
        }
    }

    private void triggerTransition() {
        class_1799 cell;
        if (!this.isClientSide() && this.isSpatialCell(cell = this.inv.getStackInSlot(0))) {
            TickHandler.instance().addCallable(null, this.transitionCallback);
        }
    }

    private boolean isSpatialCell(class_1799 cell) {
        class_1792 class_17922;
        if (!cell.method_7960() && (class_17922 = cell.method_7909()) instanceof ISpatialStorageCell) {
            ISpatialStorageCell sc = (ISpatialStorageCell)class_17922;
            return sc.isSpatialStorage(cell);
        }
        return false;
    }

    private void transition() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_1799 cell = this.inv.getStackInSlot(0);
        if (!this.isSpatialCell(cell) || !this.inv.getStackInSlot(1).method_7960()) {
            return;
        }
        ISpatialStorageCell sc = (ISpatialStorageCell)cell.method_7909();
        if (!this.getMainNode().isActive()) {
            return;
        }
        this.getMainNode().ifPresent((grid, node) -> {
            GridSpatialEvent evt;
            double req;
            ISpatialService spc = grid.getSpatialService();
            if (!spc.hasRegion() || !spc.isValidRegion()) {
                return;
            }
            IEnergyService energy = grid.getEnergyService();
            double pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (Math.abs(pr - req) < req * 0.001 && !(evt = grid.postEvent(new GridSpatialEvent(this.method_10997(), this.method_11016(), req))).isTransitionPrevented()) {
                int playerId = node.getOwningPlayerId();
                boolean success = sc.doSpatialTransition(cell, serverLevel, spc.getMin(), spc.getMax(), playerId);
                if (success) {
                    energy.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.inv.setItemDirect(0, class_1799.field_8037);
                    this.inv.setItemDirect(1, cell);
                }
            }
        });
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        return this.invExt;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    private class SpatialIOFilter
    implements IAEItemFilter {
        private SpatialIOFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 1;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return slot == 0 && SpatialIOPortBlockEntity.this.isSpatialCell(stack);
        }
    }
}

