/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.core.definitions.AEBlockEntities;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.SkyChestMenu;
import appeng.menu.locator.MenuLocators;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SkyChestBlock
extends AEBaseEntityBlock<SkyChestBlockEntity>
implements class_3737 {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<class_2350, class_265> SHAPES = new EnumMap<class_2350, class_265>(class_2350.class);
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, class_4970.class_2251 props) {
        super(props);
        this.type = type;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.horizontalFacing();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return true;
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        SkyChestBlockEntity blockEntity;
        if (!level.method_8608() && (blockEntity = (SkyChestBlockEntity)this.getBlockEntity((class_1922)level, pos)) != null) {
            MenuOpener.open(SkyChestMenu.TYPE, player, MenuLocators.forBlockEntity(blockEntity));
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_35230(pos, AEBlockEntities.SKY_CHEST).ifPresent(SkyChestBlockEntity::recheckOpen);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        SkyChestBlockEntity sk = (SkyChestBlockEntity)this.getBlockEntity(level, pos);
        class_2350 up = sk != null ? sk.getTop() : class_2350.field_11036;
        return SHAPES.get(up);
    }

    private static class_238 computeAABB(class_2350 up) {
        double offsetX = up.method_10148() == 0 ? 0.06 : 0.0;
        double offsetY = up.method_10164() == 0 ? 0.06 : 0.0;
        double offsetZ = up.method_10165() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.method_10148() < 0 ? 0.0 : (double)up.method_10148() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.method_10164() < 0 ? 0.0625 : (double)up.method_10164() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.method_10165() < 0 ? 0.0 : (double)up.method_10165() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.method_10148() < 0 ? 0.0625 : (double)up.method_10148() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.method_10164() < 0 ? 0.0 : (double)up.method_10164() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.method_10165() < 0 ? 0.0625 : (double)up.method_10165() * 0.0));
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        return (class_2680)super.method_9605(context).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    public class_2680 method_9559(class_2680 blockState, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(blockState, facing, facingState, level, currentPos, facingPos);
    }

    static {
        for (class_2350 up : class_2350.values()) {
            class_238 aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, class_259.method_1078((class_238)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

