/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class UnenchantedIngredient
extends Ingredient {
    private final IItemProvider item;

    public UnenchantedIngredient(IItemProvider item) {
        super(Stream.of(new Ingredient.SingleItemList(new ItemStack(item))));
        this.item = item;
    }

    public boolean test(ItemStack stack) {
        return super.test(stack) && !stack.func_77948_v();
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        return new JsonObject();
    }

    public static class Serializer
    implements IIngredientSerializer<UnenchantedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public UnenchantedIngredient parse(PacketBuffer buffer) {
            ItemStack stack = buffer.func_150791_c();
            return new UnenchantedIngredient((IItemProvider)stack.func_77973_b());
        }

        public UnenchantedIngredient parse(JsonObject json) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString()));
            return new UnenchantedIngredient((IItemProvider)item);
        }

        public void write(PacketBuffer buffer, UnenchantedIngredient ingredient) {
            buffer.func_150788_a(new ItemStack(ingredient.item));
        }
    }
}

