/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.modifiers;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.math.MathHelper;
import shadows.apotheosis.spawn.modifiers.SpawnerStat;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

public class SpawnerStats {
    public static final Map<String, SpawnerStat<?>> REGISTRY = new HashMap();
    public static final SpawnerStat<Integer> MIN_DELAY = SpawnerStats.register(new IntStat("min_delay", s -> s.field_145882_a.field_98283_g, (s, v) -> {
        s.field_145882_a.field_98283_g = v;
    }));
    public static final SpawnerStat<Integer> MAX_DELAY = SpawnerStats.register(new IntStat("max_delay", s -> s.field_145882_a.field_98293_h, (s, v) -> {
        s.field_145882_a.field_98293_h = v;
    }));
    public static final SpawnerStat<Integer> SPAWN_COUNT = SpawnerStats.register(new IntStat("spawn_count", s -> s.field_145882_a.field_98294_i, (s, v) -> {
        s.field_145882_a.field_98294_i = v;
    }));
    public static final SpawnerStat<Integer> MAX_NEARBY_ENTITIES = SpawnerStats.register(new IntStat("max_nearby_entities", s -> s.field_145882_a.field_98292_k, (s, v) -> {
        s.field_145882_a.field_98292_k = v;
    }));
    public static final SpawnerStat<Integer> REQ_PLAYER_RANGE = SpawnerStats.register(new IntStat("req_player_range", s -> s.field_145882_a.field_98289_l, (s, v) -> {
        s.field_145882_a.field_98289_l = v;
    }));
    public static final SpawnerStat<Integer> SPAWN_RANGE = SpawnerStats.register(new IntStat("spawn_range", s -> s.field_145882_a.field_98290_m, (s, v) -> {
        s.field_145882_a.field_98290_m = v;
    }));
    public static final SpawnerStat<Boolean> IGNORE_PLAYERS = SpawnerStats.register(new BoolStat("ignore_players", s -> s.ignoresPlayers, (s, v) -> {
        s.ignoresPlayers = v;
    }));
    public static final SpawnerStat<Boolean> IGNORE_CONDITIONS = SpawnerStats.register(new BoolStat("ignore_conditions", s -> s.ignoresConditions, (s, v) -> {
        s.ignoresConditions = v;
    }));
    public static final SpawnerStat<Boolean> REDSTONE_CONTROL = SpawnerStats.register(new BoolStat("redstone_control", s -> s.redstoneControl, (s, v) -> {
        s.redstoneControl = v;
    }));
    public static final SpawnerStat<Boolean> IGNORE_LIGHT = SpawnerStats.register(new BoolStat("ignore_light", s -> s.ignoresLight, (s, v) -> {
        s.ignoresLight = v;
    }));
    public static final SpawnerStat<Boolean> NO_AI = SpawnerStats.register(new BoolStat("no_ai", s -> s.hasNoAI, (s, v) -> {
        s.hasNoAI = v;
    }));
    public static final SpawnerStat<Boolean> SILENT = SpawnerStats.register(new BoolStat("silent", s -> s.silent, (s, v) -> {
        s.silent = v;
    }));

    private static <T extends SpawnerStat<?>> T register(T t) {
        REGISTRY.put(t.getId(), t);
        return t;
    }

    private static class IntStat
    extends Base<Integer> {
        private IntStat(String id, Function<ApothSpawnerTile, Integer> getter, BiConsumer<ApothSpawnerTile, Integer> setter) {
            super(id, getter, setter);
        }

        @Override
        public Integer parseValue(JsonElement value) {
            return value == null ? 0 : value.getAsInt();
        }

        @Override
        public boolean apply(Integer value, Integer min, Integer max, ApothSpawnerTile spawner) {
            int old = (Integer)this.getter.apply(spawner);
            this.setter.accept(spawner, MathHelper.func_76125_a((int)(old + value), (int)min, (int)max));
            return old != (Integer)this.getter.apply(spawner);
        }

        @Override
        public Class<Integer> getTypeClass() {
            return Integer.class;
        }
    }

    private static class BoolStat
    extends Base<Boolean> {
        private BoolStat(String id, Function<ApothSpawnerTile, Boolean> getter, BiConsumer<ApothSpawnerTile, Boolean> setter) {
            super(id, getter, setter);
        }

        @Override
        public Boolean parseValue(JsonElement value) {
            return value == null ? false : value.getAsBoolean();
        }

        @Override
        public boolean apply(Boolean value, Boolean min, Boolean max, ApothSpawnerTile spawner) {
            boolean old = (Boolean)this.getter.apply(spawner);
            this.setter.accept(spawner, value);
            return old != (Boolean)this.getter.apply(spawner);
        }

        @Override
        public Class<Boolean> getTypeClass() {
            return Boolean.class;
        }
    }

    private static abstract class Base<T>
    implements SpawnerStat<T> {
        protected final String id;
        protected final Function<ApothSpawnerTile, T> getter;
        protected final BiConsumer<ApothSpawnerTile, T> setter;

        private Base(String id, Function<ApothSpawnerTile, T> getter, BiConsumer<ApothSpawnerTile, T> setter) {
            this.id = id;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

