/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class KeepNBTEnchantingRecipe
extends EnchantingRecipe {
    public static final Serializer SERIALIZER = new Serializer();

    public KeepNBTEnchantingRecipe(ResourceLocation id, ItemStack output, Ingredient input, EnchantingStatManager.Stats requirements, EnchantingStatManager.Stats maxRequirements) {
        super(id, output, input, requirements, maxRequirements);
    }

    @Override
    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        ItemStack out = this.func_77571_b().func_77946_l();
        if (input.func_77942_o()) {
            out.func_77982_d(input.func_77978_p().func_74737_b());
        }
        return out;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends EnchantingRecipe.Serializer {
        @Override
        public KeepNBTEnchantingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            EnchantingStatManager.Stats maxStats;
            ItemStack output = CraftingHelper.getItemStack((JsonObject)obj.get("result").getAsJsonObject(), (boolean)true);
            Ingredient input = Ingredient.func_199802_a((JsonElement)obj.get("input"));
            EnchantingStatManager.Stats stats = (EnchantingStatManager.Stats)GSON.fromJson(obj.get("requirements"), EnchantingStatManager.Stats.class);
            EnchantingStatManager.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatManager.Stats)GSON.fromJson(obj.get("max_requirements"), EnchantingStatManager.Stats.class) : EnchantingRecipe.NO_MAX;
            if (maxStats.eterna != -1.0f && stats.eterna > maxStats.eterna) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
            }
            if (maxStats.quanta != -1.0f && stats.quanta > maxStats.quanta) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
            }
            if (maxStats.arcana != -1.0f && stats.arcana > maxStats.arcana) {
                throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
            }
            return new KeepNBTEnchantingRecipe(id, output, input, stats, maxStats);
        }
    }
}

