/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.ApothEnchantScreen;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.RealEnchantmentHelper;

public class EnchantingInfoScreen
extends Screen {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/enchanting_info.png");
    protected static TextFormatting[] colors = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.YELLOW, TextFormatting.BLUE, TextFormatting.GOLD};
    protected final ApothEnchantScreen parent;
    protected final int imageWidth;
    protected final int imageHeight;
    protected final ItemStack toEnchant;
    protected final int[] costs;
    protected final int[] clues;
    protected final int[][] powers = new int[3][];
    protected int selectedSlot = -1;
    protected int leftPos;
    protected int topPos;
    protected PowerSlider slider;
    protected int currentPower;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    List<RealEnchantmentHelper.ArcanaEnchantmentData> enchantments = Collections.emptyList();
    Map<Enchantment, List<Enchantment>> exclusions = new HashMap<Enchantment, List<Enchantment>>();

    public EnchantingInfoScreen(ApothEnchantScreen parent) {
        super((ITextComponent)new TranslationTextComponent("info.apotheosis.enchinfo_title"));
        this.parent = parent;
        this.imageWidth = 240;
        this.imageHeight = 170;
        this.toEnchant = ((ApothEnchantContainer)parent.func_212873_a_()).func_75139_a(0).func_75211_c();
        this.costs = ((ApothEnchantContainer)parent.func_212873_a_()).field_75167_g;
        this.clues = ((ApothEnchantContainer)parent.func_212873_a_()).field_185001_h;
        for (int i = 0; i < 3; ++i) {
            Enchantment clue = Enchantment.func_185262_c((int)this.clues[i]);
            if (clue == null) continue;
            int level = this.costs[i];
            float quanta = ((ApothEnchantContainer)parent.func_212873_a_()).quanta.get() / 100.0f;
            float rectification = ((ApothEnchantContainer)parent.func_212873_a_()).rectification.get() / 100.0f;
            int minPow = Math.round(MathHelper.func_76131_a((float)((float)level - (float)level * (quanta - quanta * rectification)), (float)1.0f, (float)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f)));
            int maxPow = Math.round(MathHelper.func_76131_a((float)((float)level + (float)level * quanta), (float)1.0f, (float)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f)));
            this.powers[i] = new int[]{minPow, maxPow};
            this.selectedSlot = i;
        }
    }

    protected void func_231160_c_() {
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.slider = (PowerSlider)this.func_230480_a_((Widget)new PowerSlider(this.leftPos + 5, this.topPos + 80, 80, 20));
    }

    public void func_230430_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        int i;
        int v;
        this.func_238651_a_(pPoseStack, -100);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES);
        pPoseStack.func_227860_a_();
        pPoseStack.func_227861_a_((double)this.leftPos, (double)this.topPos, 0.0);
        this.func_238474_b_(pPoseStack, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int i2 = 0; i2 < 3; ++i2) {
            Enchantment clue = Enchantment.func_185262_c((int)this.clues[i2]);
            int u = 199;
            v = 225;
            if (clue == null) {
                u += 19;
                v += 16;
            } else if (this.selectedSlot == i2 || this.isHovering(8, 18 + 19 * i2, 18, 18, pMouseX, pMouseY)) {
                u += 38;
            }
            this.func_238474_b_(pPoseStack, 8, 18 + 19 * i2, 224, u, 18, 19);
            this.func_238474_b_(pPoseStack, 9, 22 + 18 * i2 + i2, 16 * i2, v, 16, 16);
        }
        int scrollbarPos = (int)(128.0f * this.scrollOffs);
        this.func_238474_b_(pPoseStack, 220, 18 + scrollbarPos, 244, 173 + (this.isScrollBarActive() ? 0 : 15), 12, 15);
        RealEnchantmentHelper.ArcanaEnchantmentData hover = this.getHovered(pMouseX, pMouseY);
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            v = 173;
            if (hover == this.enchantments.get(this.startIndex + i)) {
                v += 13;
            }
            this.func_238474_b_(pPoseStack, 89, 18 + 13 * i, 114, v, 128, 13);
        }
        for (i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            RealEnchantmentHelper.ArcanaEnchantmentData data = this.enchantments.get(this.startIndex + i);
            this.field_230712_o_.func_238421_b_(pPoseStack, I18n.func_135052_a((String)data.data.field_76302_b.func_77320_a(), (Object[])new Object[0]), 91.0f, (float)(21 + 13 * i), 0xFFFF80);
        }
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
        ApothEnchantContainer.Arcana a = ApothEnchantContainer.Arcana.getForThreshold(((ApothEnchantContainer)this.parent.func_212873_a_()).arcana.get());
        list.add(new TranslationTextComponent("info.apotheosis.weights").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.YELLOW}));
        list.add(new TranslationTextComponent("info.apotheosis.weight", new Object[]{I18n.func_135052_a((String)"rarity.enchantment.common", (Object[])new Object[0]), a.rarities[0]}).func_240699_a_(TextFormatting.GRAY));
        list.add(new TranslationTextComponent("info.apotheosis.weight", new Object[]{I18n.func_135052_a((String)"rarity.enchantment.uncommon", (Object[])new Object[0]), a.rarities[1]}).func_240699_a_(TextFormatting.GREEN));
        list.add(new TranslationTextComponent("info.apotheosis.weight", new Object[]{I18n.func_135052_a((String)"rarity.enchantment.rare", (Object[])new Object[0]), a.rarities[2]}).func_240699_a_(TextFormatting.BLUE));
        list.add(new TranslationTextComponent("info.apotheosis.weight", new Object[]{I18n.func_135052_a((String)"rarity.enchantment.very_rare", (Object[])new Object[0]), a.rarities[3]}).func_240699_a_(TextFormatting.GOLD));
        this.func_243308_b(pPoseStack, list, a == ApothEnchantContainer.Arcana.MAX ? -2 : 1, 120);
        this.field_230712_o_.func_243248_b(pPoseStack, this.field_230704_d_, 7.0f, 4.0f, 0x404040);
        pPoseStack.func_227865_b_();
        pPoseStack.func_227861_a_(0.0, 0.0, 10.0);
        for (int i3 = 0; i3 < 3; ++i3) {
            if (!this.isHovering(8, 18 + 19 * i3, 18, 18, pMouseX, pMouseY)) continue;
            list.clear();
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_slot", new Object[]{i3 + 1}).func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.UNDERLINE}));
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_level", new Object[]{this.costs[i3]}).func_240699_a_(TextFormatting.GREEN));
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_minpow", new Object[]{this.powers[i3][0]}).func_240699_a_(TextFormatting.DARK_RED));
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_maxpow", new Object[]{this.powers[i3][1]}).func_240699_a_(TextFormatting.BLUE));
            this.func_243308_b(pPoseStack, list, pMouseX, pMouseY);
        }
        if (hover != null) {
            List<Enchantment> excls;
            list.clear();
            list.add(new TranslationTextComponent(hover.data.field_76302_b.func_77320_a()).func_240701_a_(new TextFormatting[]{TextFormatting.GREEN, TextFormatting.UNDERLINE}));
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_level", new Object[]{new TranslationTextComponent("enchantment.level." + hover.data.field_76303_c)}).func_240699_a_(TextFormatting.DARK_AQUA));
            IFormattableTextComponent rarity = new TranslationTextComponent("rarity.enchantment." + hover.data.field_76302_b.func_77324_c().name().toLowerCase(Locale.ROOT)).func_240699_a_(colors[hover.data.field_76302_b.func_77324_c().ordinal()]);
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_rarity", new Object[]{rarity}).func_240699_a_(TextFormatting.DARK_AQUA));
            list.add(new TranslationTextComponent("info.apotheosis.enchinfo_chance", new Object[]{String.format("%.2f", Float.valueOf(100.0f * (float)hover.field_76292_a / (float)WeightedRandom.func_76272_a(this.enchantments))) + "%"}).func_240699_a_(TextFormatting.DARK_AQUA));
            if (I18n.func_188566_a((String)(hover.data.field_76302_b.func_77320_a() + ".desc"))) {
                list.add(new TranslationTextComponent(hover.data.field_76302_b.func_77320_a() + ".desc").func_240699_a_(TextFormatting.DARK_AQUA));
            }
            if (!(excls = this.exclusions.get(hover.data.field_76302_b)).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i4 = 0; i4 < excls.size(); ++i4) {
                    sb.append(I18n.func_135052_a((String)excls.get(i4).func_77320_a(), (Object[])new Object[0]));
                    if (i4 == excls.size() - 1) continue;
                    sb.append(", ");
                }
                list.add(new TranslationTextComponent("Exclusive With: %s", new Object[]{sb.toString()}).func_240699_a_(TextFormatting.RED));
            }
            this.func_243308_b(pPoseStack, list, pMouseX, pMouseY);
        }
        this.func_230926_e_(2001);
        this.field_230707_j_.field_77023_b = 2001.0f;
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.toEnchant, this.leftPos + 49, this.topPos + 39);
        Minecraft.func_71410_x().func_175599_af().func_175030_a(this.field_230712_o_, this.toEnchant, this.leftPos + 49, this.topPos + 39);
        this.field_230707_j_.field_77023_b = 0.0f;
        this.func_230926_e_(0);
        pPoseStack.func_227861_a_(0.0, 0.0, -10.0);
        super.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.leftPos + 220;
        int top = this.topPos + 18;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 143)) {
            this.scrolling = true;
            this.func_231045_a_(pMouseX, pMouseY, 0, pMouseX, pMouseY);
        }
        for (int i = 0; i < 3; ++i) {
            Enchantment clue = Enchantment.func_185262_c((int)this.clues[i]);
            if (this.selectedSlot == i || clue == null || !this.isHovering(8, 18 + 19 * i, 18, 18, pMouseX, pMouseY)) continue;
            this.selectedSlot = i;
            this.slider.setValue((this.slider.min() + this.slider.max()) / 2);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return super.func_231044_a_(pMouseX, pMouseY, pButton);
    }

    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 18;
            int j = i + 143;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean func_231043_a_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = MathHelper.func_76131_a((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.enchantments.size() > 11;
    }

    protected int getOffscreenRows() {
        return this.enchantments.size() - 11;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    protected void recomputeEnchantments() {
        ApothEnchantContainer.Arcana arc = ApothEnchantContainer.Arcana.getForThreshold(((ApothEnchantContainer)this.parent.func_212873_a_()).arcana.get());
        this.enchantments = RealEnchantmentHelper.getAvailableEnchantmentResults(this.currentPower, this.toEnchant, false).stream().map(e -> new RealEnchantmentHelper.ArcanaEnchantmentData(arc, (EnchantmentData)e)).collect(Collectors.toList());
        if (this.startIndex + 11 >= this.enchantments.size()) {
            this.startIndex = 0;
            this.scrollOffs = 0.0f;
        }
        this.exclusions.clear();
        for (RealEnchantmentHelper.ArcanaEnchantmentData d : this.enchantments) {
            ArrayList<Enchantment> excls = new ArrayList<Enchantment>();
            for (RealEnchantmentHelper.ArcanaEnchantmentData d2 : this.enchantments) {
                if (d == d2 || d.data.field_76302_b.func_191560_c(d2.data.field_76302_b)) continue;
                excls.add(d2.data.field_76302_b);
            }
            this.exclusions.put(d.data.field_76302_b, excls);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected RealEnchantmentHelper.ArcanaEnchantmentData getHovered(double mouseX, double mouseY) {
        for (int i = 0; i < 11 && this.enchantments.size() - 1 >= i; ++i) {
            if (!this.isHovering(89, 18 + i * 13, 128, 13, mouseX, mouseY)) continue;
            return this.enchantments.get(this.startIndex + i);
        }
        return null;
    }

    public class PowerSlider
    extends AbstractSlider {
        public PowerSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (ITextComponent)new StringTextComponent(""), 0.0);
            if (EnchantingInfoScreen.this.selectedSlot != -1 && this.field_230683_b_ == 0.0) {
                this.field_230683_b_ = this.normalizeValue(EnchantingInfoScreen.this.currentPower == 0 ? (double)((this.max() + this.min()) / 2) : (double)EnchantingInfoScreen.this.currentPower);
                this.func_230972_a_();
            }
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("info.apotheosis.slider_power", new Object[]{EnchantingInfoScreen.this.currentPower}));
        }

        protected void func_230972_a_() {
            EnchantingInfoScreen.this.currentPower = this.denormalizeValue(this.field_230683_b_);
            EnchantingInfoScreen.this.recomputeEnchantments();
        }

        public void setValue(int value) {
            if (!EnchantingInfoScreen.this.func_231041_ay__()) {
                this.field_230683_b_ = this.normalizeValue(value);
                this.func_230972_a_();
                this.func_230979_b_();
            }
        }

        public double normalizeValue(double value) {
            return MathHelper.func_151237_a((double)((this.snapToStepClamp(value) - (double)this.min()) / (double)(this.max() - this.min())), (double)0.0, (double)1.0);
        }

        public int denormalizeValue(double value) {
            return (int)this.snapToStepClamp(MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.min(), (double)this.max()));
        }

        private double snapToStepClamp(double valueIn) {
            if (this.step() > 0.0f) {
                valueIn = this.step() * (float)Math.round(valueIn / (double)this.step());
            }
            return MathHelper.func_151237_a((double)valueIn, (double)this.min(), (double)this.max());
        }

        private int min() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][0];
        }

        private int max() {
            return EnchantingInfoScreen.this.powers[EnchantingInfoScreen.this.selectedSlot][1];
        }

        private float step() {
            return 1.0f / (float)Math.max(this.max() - this.min(), 1);
        }
    }
}

