/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.advancements.EnchantedTrigger;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.ClueMessage;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.IEnchantableItem;
import shadows.apotheosis.ench.table.RealEnchantmentHelper;
import shadows.apotheosis.util.FloatReferenceHolder;
import shadows.placebo.util.NetworkUtils;

public class ApothEnchantContainer
extends EnchantmentContainer {
    protected final FloatReferenceHolder eterna = new FloatReferenceHolder(0.0f, 0.0f, EnchantingStatManager.getAbsoluteMaxEterna());
    protected final FloatReferenceHolder quanta = new FloatReferenceHolder(0.0f, 0.0f, 100.0f);
    protected final FloatReferenceHolder arcana = new FloatReferenceHolder(0.0f, 0.0f, 100.0f);
    protected final FloatReferenceHolder rectification = new FloatReferenceHolder(0.0f, -100.0f, 100.0f);
    protected final IntReferenceHolder clues = IntReferenceHolder.func_221492_a();
    protected final PlayerEntity player;

    public ApothEnchantContainer(int id, PlayerInventory inv) {
        super(id, inv, IWorldPosCallable.field_221489_a);
        this.player = inv.field_70458_d;
        this.field_75151_b.clear();
        this.addSecretSlot(new Slot(this.field_75168_e, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.addSecretSlot(new Slot(this.field_75168_e, 1, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.GEMS_LAPIS.func_230235_a_((Object)stack.func_77973_b());
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantContainer(int id, PlayerInventory inv, IWorldPosCallable wPos, ApothEnchantTile te) {
        super(id, inv, wPos);
        this.player = inv.field_70458_d;
        this.field_75151_b.clear();
        this.addSecretSlot(new Slot(this.field_75168_e, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.addSecretSlot((Slot)new SlotItemHandler((IItemHandler)te.inv, 0, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.GEMS_LAPIS.func_230235_a_((Object)stack.func_77973_b());
            }
        });
        this.initCommon(inv);
    }

    protected Slot addSecretSlot(Slot pSlot) {
        pSlot.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(pSlot);
        return pSlot;
    }

    private void initCommon(PlayerInventory inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSecretSlot(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSecretSlot(new Slot((IInventory)inv, k, 8 + k * 18, 173));
        }
        this.func_216961_a((IIntArray)this.eterna.getArray());
        this.func_216961_a((IIntArray)this.quanta.getArray());
        this.func_216961_a((IIntArray)this.arcana.getArray());
        this.func_216961_a((IIntArray)this.rectification.getArray());
        this.clues.func_221494_a(0);
        this.func_216958_a(this.clues);
    }

    public boolean func_75140_a(PlayerEntity player, int id) {
        int level = this.field_75167_g[id];
        ItemStack toEnchant = this.field_75168_e.func_70301_a(0);
        ItemStack lapis = this.func_75139_a(1).func_75211_c();
        int cost = id + 1;
        if ((lapis.func_190926_b() || lapis.func_190916_E() < cost) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.field_75167_g[id] <= 0 || toEnchant.func_190926_b() || (player.field_71068_ca < cost || player.field_71068_ca < this.field_75167_g[id]) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        this.field_217006_g.func_221486_a((world, pos) -> {
            ItemStack enchanted = toEnchant;
            float eterna = this.eterna.get();
            float quanta = this.quanta.get();
            float arcana = this.arcana.get();
            float rectification = this.rectification.get();
            List<EnchantmentData> list = this.getEnchantmentList(toEnchant, id, this.field_75167_g[id]);
            if (list.isEmpty()) return;
            player.func_192024_a(toEnchant, cost);
            if (list.get((int)0).field_76302_b == ApotheosisObjects.INFUSION) {
                EnchantingRecipe match = EnchantingRecipe.findMatch(world, toEnchant, eterna, quanta, arcana);
                if (match == null) return;
                this.field_75168_e.func_70299_a(0, match.assemble(toEnchant, eterna, quanta, arcana));
            } else {
                this.field_75168_e.func_70299_a(0, ((IEnchantableItem)toEnchant.func_77973_b()).onEnchantment(toEnchant, list));
            }
            if (!player.field_71075_bZ.field_75098_d) {
                lapis.func_190918_g(cost);
                if (lapis.func_190926_b()) {
                    this.field_75168_e.func_70299_a(1, ItemStack.field_190927_a);
                }
            }
            player.func_195066_a(Stats.field_188091_Y);
            if (player instanceof ServerPlayerEntity) {
                ((EnchantedTrigger)CriteriaTriggers.field_192129_i).trigger((ServerPlayerEntity)player, enchanted, level, eterna, quanta, arcana, rectification);
            }
            this.field_75168_e.func_70296_d();
            this.field_178149_f.func_221494_a(player.func_175138_ci());
            this.func_75130_a(this.field_75168_e);
            world.func_184133_a(null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        });
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.field_217006_g.func_221484_a((world, pos) -> {
            if (inventoryIn == this.field_75168_e) {
                ItemStack toEnchant = inventoryIn.func_70301_a(0);
                this.gatherStats();
                EnchantingRecipe match = EnchantingRecipe.findItemMatch(world, toEnchant);
                if (toEnchant.func_190916_E() == 1 && (match != null || toEnchant.func_77973_b().func_77616_k(toEnchant) && ApothEnchantContainer.isEnchantableEnough(toEnchant))) {
                    int slot;
                    float eterna = this.eterna.get();
                    if ((double)eterna < 1.5) {
                        eterna = 1.5f;
                    }
                    this.field_75169_l.setSeed(this.field_178149_f.func_221495_b());
                    for (slot = 0; slot < 3; ++slot) {
                        this.field_75167_g[slot] = RealEnchantmentHelper.getEnchantmentCost(this.field_75169_l, slot, eterna, toEnchant);
                        this.field_185001_h[slot] = -1;
                        this.field_185002_i[slot] = -1;
                        if (this.field_75167_g[slot] < slot + 1) {
                            int n = slot;
                            this.field_75167_g[n] = this.field_75167_g[n] + 1;
                        }
                        this.field_75167_g[slot] = ForgeEventFactory.onEnchantmentLevelSet((World)world, (BlockPos)pos, (int)slot, (int)Math.round(eterna), (ItemStack)toEnchant, (int)this.field_75167_g[slot]);
                    }
                    for (slot = 0; slot < 3; ++slot) {
                        List<EnchantmentData> list;
                        if (this.field_75167_g[slot] <= 0 || (list = this.getEnchantmentList(toEnchant, slot, this.field_75167_g[slot])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.remove(this.field_75169_l.nextInt(list.size()));
                        this.field_185001_h[slot] = Registry.field_212628_q.func_148757_b((Object)enchantmentdata.field_76302_b);
                        this.field_185002_i[slot] = enchantmentdata.field_76303_c;
                        int clues = 1 + this.clues.func_221495_b();
                        ArrayList<EnchantmentData> clueList = new ArrayList<EnchantmentData>();
                        if (clues-- > 0) {
                            clueList.add(enchantmentdata);
                        }
                        while (clues-- > 0 && !list.isEmpty()) {
                            clueList.add(list.remove(this.field_75169_l.nextInt(list.size())));
                        }
                        NetworkUtils.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)((Object)new ClueMessage(slot, clueList, list.isEmpty())), (PlayerEntity)this.player);
                    }
                    this.func_75142_b();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.field_75167_g[i] = 0;
                        this.field_185001_h[i] = -1;
                        this.field_185002_i[i] = -1;
                    }
                    this.eterna.set(0.0f);
                    this.quanta.set(0.0f);
                    this.arcana.set(0.0f);
                }
            }
            return this;
        });
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.field_75169_l.setSeed(this.field_178149_f.func_221495_b() + enchantSlot);
        List<EnchantmentData> list = RealEnchantmentHelper.selectEnchantment(this.field_75169_l, stack, level, this.quanta.get(), this.arcana.get(), this.rectification.get(), false);
        EnchantingRecipe match = ((Optional)this.field_217006_g.func_221484_a((world, pos) -> Optional.ofNullable(EnchantingRecipe.findMatch(world, stack, this.eterna.get(), this.quanta.get(), this.arcana.get()))).get()).orElse(null);
        if (enchantSlot == 2 && match != null) {
            list.clear();
            list.add(new EnchantmentData(ApotheosisObjects.INFUSION, 1));
        }
        return list;
    }

    public void gatherStats() {
        this.field_217006_g.func_221484_a((world, pos) -> {
            Float2FloatOpenHashMap eternaMap = new Float2FloatOpenHashMap();
            float[] stats = new float[]{0.0f, 15.0f, 0.0f, 0.0f, 0.0f};
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (j == 0 && k == 0 || !world.func_175623_d(pos.func_177982_a(k, 0, j)) || !world.func_175623_d(pos.func_177982_a(k, 1, j))) continue;
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 0, j * 2));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 1, j * 2));
                    if (k == 0 || j == 0) continue;
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 0, j));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 1, j));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k, 0, j * 2));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k, 1, j * 2));
                }
            }
            ArrayList entries = new ArrayList(eternaMap.float2FloatEntrySet());
            Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
            for (Float2FloatMap.Entry e : entries) {
                if (e.getFloatKey() > 0.0f) {
                    stats[0] = Math.min(e.getFloatKey(), stats[0] + e.getFloatValue());
                    continue;
                }
                stats[0] = stats[0] + e.getFloatValue();
            }
            this.eterna.set(stats[0]);
            this.quanta.set(stats[1]);
            this.arcana.set(stats[2] + (float)this.func_75139_a(0).func_75211_c().getItemEnchantability() / 2.0f);
            this.rectification.set(stats[3]);
            this.clues.func_221494_a((int)stats[4]);
            return this;
        }).orElse(this);
    }

    public static void gatherStats(Float2FloatMap eternaMap, float[] stats, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos)) {
            return;
        }
        float max = EnchantingStatManager.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatManager.getEterna(state, world, pos);
        eternaMap.put(max, eternaMap.getOrDefault(max, 0.0f) + eterna);
        float quanta = EnchantingStatManager.getQuanta(state, world, pos);
        stats[1] = stats[1] + quanta;
        float arcana = EnchantingStatManager.getArcana(state, world, pos);
        stats[2] = stats[2] + arcana;
        float quantaRec = EnchantingStatManager.getQuantaRectification(state, world, pos);
        stats[3] = stats[3] + quantaRec;
        int clues = EnchantingStatManager.getBonusClues(state, world, pos);
        stats[4] = stats[4] + (float)clues;
    }

    public ContainerType<?> func_216957_a() {
        return ApotheosisObjects.ENCHANTING;
    }

    public static boolean isEnchantableEnough(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return true;
        }
        return EnchantmentHelper.func_82781_a((ItemStack)stack).keySet().stream().allMatch(Enchantment::func_190936_d);
    }

    public static enum Arcana {
        EMPTY(0.0f, 10, 5, 2, 1),
        LITTLE(10.0f, 8, 5, 3, 1),
        FEW(20.0f, 7, 5, 4, 2),
        SOME(30.0f, 5, 5, 4, 2),
        LESS(40.0f, 5, 5, 4, 3),
        MEDIUM(50.0f, 5, 5, 5, 5),
        MORE(60.0f, 3, 4, 5, 5),
        VALUE(70.0f, 2, 4, 5, 5),
        EXTRA(80.0f, 2, 4, 5, 7),
        ALMOST(90.0f, 1, 3, 5, 8),
        MAX(99.0f, 1, 2, 5, 10);

        final float threshold;
        final int[] rarities;
        static Arcana[] VALUES;

        private Arcana(float threshold, int ... rarities) {
            this.threshold = threshold;
            this.rarities = rarities;
        }

        public int[] getRarities() {
            return this.rarities;
        }

        public static Arcana getForThreshold(float threshold) {
            for (int i = VALUES.length - 1; i >= 0; --i) {
                if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
                return VALUES[i];
            }
            return EMPTY;
        }

        static {
            VALUES = Arcana.values();
        }
    }
}

