/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.compat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.compat.EnchantingCategory;
import shadows.apotheosis.ench.table.EnchantingRecipe;

@JeiPlugin
public class EnchJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "enchantment");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enableEnch) {
            return;
        }
        ItemStack enchDiaSword = new ItemStack((IItemProvider)Items.field_151048_u);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_185302_k, (Object)1), (ItemStack)enchDiaSword);
        ItemStack cursedDiaSword = new ItemStack((IItemProvider)Items.field_151048_u);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_190941_k, (Object)1), (ItemStack)cursedDiaSword);
        ItemStack enchBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_185302_k, (Object)1), (ItemStack)enchBook);
        IVanillaRecipeFactory factory = reg.getVanillaRecipeFactory();
        reg.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(enchDiaSword, (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Blocks.field_196553_aF)), (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151048_u))), (Object)factory.createAnvilRecipe(cursedDiaSword, (List)ImmutableList.of((Object)new ItemStack((IItemProvider)ApotheosisObjects.PRISMATIC_WEB)), (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151048_u))), (Object)factory.createAnvilRecipe(enchDiaSword, (List)ImmutableList.of((Object)new ItemStack((IItemProvider)ApotheosisObjects.SCRAP_TOME)), (List)ImmutableList.of((Object)enchBook)), (Object)factory.createAnvilRecipe(new ItemStack((IItemProvider)Blocks.field_196718_eZ), (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Blocks.field_150339_S)), (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Blocks.field_150467_bQ)))), VanillaRecipeCategoryUid.ANVIL);
        reg.addIngredientInfo((Object)new ItemStack((IItemProvider)Blocks.field_150381_bn), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("info.apotheosis.enchanting")});
        reg.addIngredientInfo((Object)new ItemStack((IItemProvider)ApotheosisObjects.ENCHANTMENT_LIBRARY), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("info.apotheosis.library")});
        List recipes = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_241447_a_(EnchantingRecipe.TYPE);
        recipes.sort((r1, r2) -> Float.compare(r1.getRequirements().eterna, r2.getRequirements().eterna));
        reg.addRecipes((Collection)recipes, EnchantingCategory.UID);
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter(ApotheosisObjects.HELLSHELF.func_199767_j(), (IIngredientSubtypeInterpreter)new ShelfSubtypes(stk -> EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.HELL_INFUSION, (ItemStack)stk)));
        reg.registerSubtypeInterpreter(ApotheosisObjects.SEASHELF.func_199767_j(), (IIngredientSubtypeInterpreter)new ShelfSubtypes(stk -> EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SEA_INFUSION, (ItemStack)stk)));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        if (!Apotheosis.enableEnch) {
            return;
        }
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150381_bn), new ResourceLocation[]{EnchantingCategory.UID});
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        if (!Apotheosis.enableEnch) {
            return;
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new EnchantingCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    private class ShelfSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private final Function<ItemStack, Integer> getter;

        private ShelfSubtypes(Function<ItemStack, Integer> getter) {
            this.getter = getter;
        }

        public String apply(ItemStack stack, UidContext context) {
            if (this.getter.apply(stack) >= 3) {
                return "infused";
            }
            return "std";
        }
    }
}

