/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.compat;

import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shadows.apotheosis.ench.table.EnchantingStatManager;

public class CommonTooltipUtil {
    public static void appendBlockStats(World world, BlockState state, Consumer<ITextComponent> tooltip) {
        float maxEterna = EnchantingStatManager.getMaxEterna(state, world, BlockPos.field_177992_a);
        float eterna = EnchantingStatManager.getEterna(state, world, BlockPos.field_177992_a);
        float quanta = EnchantingStatManager.getQuanta(state, world, BlockPos.field_177992_a);
        float arcana = EnchantingStatManager.getArcana(state, world, BlockPos.field_177992_a);
        float rectification = EnchantingStatManager.getQuantaRectification(state, world, BlockPos.field_177992_a);
        int clues = EnchantingStatManager.getBonusClues(state, world, BlockPos.field_177992_a);
        if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f || rectification != 0.0f || clues != 0) {
            tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.ench_stats").func_240699_a_(TextFormatting.GOLD));
        }
        if (eterna != 0.0f) {
            if (eterna > 0.0f) {
                tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.eterna.p", new Object[]{String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))}).func_240699_a_(TextFormatting.GREEN));
            } else {
                tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.eterna", new Object[]{String.format("%.2f", Float.valueOf(eterna))}).func_240699_a_(TextFormatting.GREEN));
            }
        }
        if (quanta != 0.0f) {
            tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.quanta" + (quanta > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(quanta))}).func_240699_a_(TextFormatting.RED));
        }
        if (arcana != 0.0f) {
            tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.arcana" + (arcana > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(arcana))}).func_240699_a_(TextFormatting.DARK_PURPLE));
        }
        if (rectification != 0.0f) {
            tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.rectification" + (rectification > 0.0f ? ".p" : ""), new Object[]{String.format("%.2f", Float.valueOf(rectification))}).func_240699_a_(TextFormatting.YELLOW));
        }
        if (clues != 0) {
            tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.clues" + (clues > 0 ? ".p" : ""), new Object[]{String.format("%d", clues)}).func_240699_a_(TextFormatting.DARK_AQUA));
        }
    }

    public static void appendTableStats(World world, BlockPos pos, Consumer<ITextComponent> tooltip) {
        Float2FloatOpenHashMap eternaMap = new Float2FloatOpenHashMap();
        float[] stats = new float[]{0.0f, 15.0f, 0.0f, 0.0f, 0.0f};
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !world.func_175623_d(pos.func_177982_a(k, 0, j)) || !world.func_175623_d(pos.func_177982_a(k, 1, j))) continue;
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 0, j * 2));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 0, j));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k * 2, 1, j));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k, 0, j * 2));
                CommonTooltipUtil.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.func_177982_a(k, 1, j * 2));
            }
        }
        ArrayList entries = new ArrayList(eternaMap.float2FloatEntrySet());
        Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
        for (Float2FloatMap.Entry e : entries) {
            if (e.getFloatKey() > 0.0f) {
                stats[0] = Math.min(e.getFloatKey(), stats[0] + e.getFloatValue());
                continue;
            }
            stats[0] = stats[0] + e.getFloatValue();
        }
        tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.eterna.t", new Object[]{String.format("%.2f", Float.valueOf(stats[0])), String.format("%.2f", Float.valueOf(EnchantingStatManager.getAbsoluteMaxEterna()))}).func_240699_a_(TextFormatting.GREEN));
        tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.quanta.t", new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats[1])))}).func_240699_a_(TextFormatting.RED));
        tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.arcana.t", new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats[2])))}).func_240699_a_(TextFormatting.DARK_PURPLE));
        tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.rectification.t", new Object[]{String.format("%.2f", Float.valueOf(MathHelper.func_76131_a((float)stats[3], (float)-100.0f, (float)100.0f)))}).func_240699_a_(TextFormatting.YELLOW));
        tooltip.accept((ITextComponent)new TranslationTextComponent("info.apotheosis.clues.t", new Object[]{String.format("%d", (int)stats[4] + 1)}).func_240699_a_(TextFormatting.DARK_AQUA));
    }

    public static void gatherStats(Float2FloatMap eternaMap, float[] stats, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos)) {
            return;
        }
        float max = EnchantingStatManager.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatManager.getEterna(state, world, pos);
        eternaMap.put(max, eternaMap.getOrDefault(max, 0.0f) + eterna);
        float quanta = EnchantingStatManager.getQuanta(state, world, pos);
        stats[1] = stats[1] + quanta;
        float arcana = EnchantingStatManager.getArcana(state, world, pos);
        stats[2] = stats[2] + arcana;
        float quantaRec = EnchantingStatManager.getQuantaRectification(state, world, pos);
        stats[3] = stats[3] + quantaRec;
        int clues = EnchantingStatManager.getBonusClues(state, world, pos);
        stats[4] = stats[4] + (float)clues;
    }
}

