/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.tool;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;
import shadows.apotheosis.deadly.config.DeadlyConfig;

public class TorchPlacementAffix
extends Affix {
    public TorchPlacementAffix(int weight) {
        super(weight);
    }

    @Override
    public float generateLevel(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        int duraCost = 4 + rand.nextInt(5);
        if (modifier != null) {
            duraCost = (int)modifier.editLevel(this, duraCost);
        }
        return 9 - duraCost;
    }

    @Override
    public float getMin() {
        return 4.0f;
    }

    @Override
    public float getMax() {
        return 8.0f;
    }

    @Override
    public float upgradeLevel(float curLvl, float newLvl) {
        return Math.min(curLvl, newLvl);
    }

    @Override
    public float obliterateLevel(float level) {
        return Math.min(9.0f, level * 2.0f);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.PICKAXE || type == EquipmentType.SHOVEL;
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext ctx, float level) {
        PlayerEntity player = ctx.func_195999_j();
        if (DeadlyConfig.torchItem.get().func_195939_a(ctx).func_226246_a_()) {
            if (ctx.func_195996_i().func_190926_b()) {
                ctx.func_195996_i().func_190917_f(1);
            }
            player.func_184586_b(ctx.func_221531_n()).func_222118_a((int)level, (LivingEntity)player, p -> p.func_213361_c(EquipmentSlotType.MAINHAND));
            return ActionResultType.SUCCESS;
        }
        return null;
    }
}

