/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.modifiers.SpawnerStats;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;

public class ModifierTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("apotheosis", "spawner_modifier");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners == null) {
            ModifierTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, ModifierTrigger$listeners);
        }
        ModifierTrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.remove(listener);
            if (ModifierTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, ConditionArrayParser conditionsParser) {
        MinMaxBounds.IntBound minDelay = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.MIN_DELAY.getId()));
        MinMaxBounds.IntBound maxDelay = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.MAX_DELAY.getId()));
        MinMaxBounds.IntBound spawnCount = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.SPAWN_COUNT.getId()));
        MinMaxBounds.IntBound nearbyEnts = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.MAX_NEARBY_ENTITIES.getId()));
        MinMaxBounds.IntBound playerRange = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.REQ_PLAYER_RANGE.getId()));
        MinMaxBounds.IntBound spawnRange = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get(SpawnerStats.SPAWN_RANGE.getId()));
        Boolean ignorePlayers = json.has(SpawnerStats.IGNORE_PLAYERS.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_PLAYERS.getId()).getAsBoolean()) : null;
        Boolean ignoreConditions = json.has(SpawnerStats.IGNORE_CONDITIONS.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_CONDITIONS.getId()).getAsBoolean()) : null;
        Boolean redstone = json.has(SpawnerStats.REDSTONE_CONTROL.getId()) ? Boolean.valueOf(json.get(SpawnerStats.REDSTONE_CONTROL.getId()).getAsBoolean()) : null;
        Boolean ignoreLight = json.has(SpawnerStats.IGNORE_LIGHT.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_LIGHT.getId()).getAsBoolean()) : null;
        Boolean noAI = json.has(SpawnerStats.NO_AI.getId()) ? Boolean.valueOf(json.get(SpawnerStats.NO_AI.getId()).getAsBoolean()) : null;
        return new Instance(minDelay, maxDelay, spawnCount, nearbyEnts, playerRange, spawnRange, ignorePlayers, ignoreConditions, redstone, ignoreLight, noAI);
    }

    public void trigger(ServerPlayerEntity player, ApothSpawnerTile tile, SpawnerModifier modif) {
        Listeners ModifierTrigger$listeners = this.listeners.get(player.func_192039_O());
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.trigger(tile, modif);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ApothSpawnerTile tile, SpawnerModifier modif) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(tile, modif)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final MinMaxBounds.IntBound minDelay;
        private final MinMaxBounds.IntBound maxDelay;
        private final MinMaxBounds.IntBound spawnCount;
        private final MinMaxBounds.IntBound nearbyEnts;
        private final MinMaxBounds.IntBound playerRange;
        private final MinMaxBounds.IntBound spawnRange;
        private final Boolean ignorePlayers;
        private final Boolean ignoreConditions;
        private final Boolean redstone;
        private final Boolean ignoreLight;
        private final Boolean noAI;

        public Instance(MinMaxBounds.IntBound minDelay, MinMaxBounds.IntBound maxDelay, MinMaxBounds.IntBound spawnCount, MinMaxBounds.IntBound nearbyEnts, MinMaxBounds.IntBound playerRange, MinMaxBounds.IntBound spawnRange, Boolean ignorePlayers, Boolean ignoreConditions, Boolean redstone, Boolean ignoreLight, Boolean noAI) {
            super(ID, EntityPredicate.AndPredicate.field_234582_a_);
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.spawnCount = spawnCount;
            this.nearbyEnts = nearbyEnts;
            this.playerRange = playerRange;
            this.spawnRange = spawnRange;
            this.ignorePlayers = ignorePlayers;
            this.ignoreConditions = ignoreConditions;
            this.redstone = redstone;
            this.ignoreLight = ignoreLight;
            this.noAI = noAI;
        }

        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            return new JsonObject();
        }

        public boolean test(ApothSpawnerTile tile, SpawnerModifier modif) {
            ApothSpawnerTile.SpawnerLogicExt logic = (ApothSpawnerTile.SpawnerLogicExt)tile.field_145882_a;
            if (!this.minDelay.func_211339_d(logic.field_98283_g)) {
                return false;
            }
            if (!this.maxDelay.func_211339_d(logic.field_98293_h)) {
                return false;
            }
            if (!this.spawnCount.func_211339_d(logic.field_98294_i)) {
                return false;
            }
            if (!this.nearbyEnts.func_211339_d(logic.field_98292_k)) {
                return false;
            }
            if (!this.playerRange.func_211339_d(logic.field_98289_l)) {
                return false;
            }
            if (!this.spawnRange.func_211339_d(logic.field_98290_m)) {
                return false;
            }
            if (this.ignorePlayers != null && tile.ignoresPlayers != this.ignorePlayers) {
                return false;
            }
            if (this.ignoreConditions != null && tile.ignoresConditions != this.ignoreConditions) {
                return false;
            }
            if (this.redstone != null && tile.redstoneControl != this.redstone) {
                return false;
            }
            if (this.ignoreLight != null && tile.ignoresLight != this.ignoreLight) {
                return false;
            }
            return this.noAI == null || tile.hasNoAI == this.noAI;
        }
    }
}

