/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.mixin;

import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.providers.HarvestInfoTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={HarvestInfoTools.class})
public class TopOTheMornin {
    @Shadow(remap=true)
    private static String[] harvestLevels = new String[]{"wood", "stone", "iron", "diamond", "netherite", "allthemodium", "vibranium", "unobtainium"};
    @Final
    @Shadow
    private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");
    @Final
    @Shadow
    private static final Map<ToolType, ItemStack> TEST_TOOLS = new HashMap<ToolType, ItemStack>();

    @Overwrite
    static void showHarvestInfo(IProbeInfo probeInfo, World world, BlockPos pos, Block block, BlockState blockState, PlayerEntity player) {
        boolean v;
        float blockHardness;
        boolean harvestable = block.canHarvestBlock(world.func_180495_p(pos), (IBlockReader)world, pos, player) && world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) >= 0.0f;
        ToolType harvestTool = block.getHarvestTool(blockState);
        String harvestName = null;
        if (harvestTool == null && (blockHardness = blockState.func_185887_b((IBlockReader)world, pos)) > 0.0f) {
            for (Map.Entry<ToolType, ItemStack> testToolEntry : TEST_TOOLS.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ToolItem)) continue;
                ToolItem toolItem = (ToolItem)testTool.func_77973_b();
                if (!(testTool.func_150997_a(blockState) >= toolItem.func_200891_e().func_200928_b())) continue;
                harvestTool = testToolEntry.getKey();
                break;
            }
        }
        int harvestLevel = block.getHarvestLevel(blockState);
        if (harvestTool != null && harvestLevel >= 0 && harvestLevel < harvestLevels.length) {
            harvestName = harvestLevels[harvestLevel];
        }
        int offs = (v = ((Boolean)Config.harvestStyleVanilla.get()).booleanValue()) ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestLevel < 0) {
            harvestLevel = 0;
            harvestName = "wood";
        }
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.OK).text((harvestTool != null ? harvestTool.getName() : "No tool") + " (" + harvestName + " T" + harvestLevel + ")"));
        } else if (harvestName != null && !harvestName.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text((harvestTool != null ? harvestTool.getName() : "No tool") + " (" + harvestName + " T" + harvestLevel + ")"));
        } else {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text(harvestTool != null ? harvestTool.getName() : "No tool"));
        }
    }

    static {
        TEST_TOOLS.put(ToolType.SHOVEL, new ItemStack((IItemProvider)Items.field_151038_n));
        TEST_TOOLS.put(ToolType.AXE, new ItemStack((IItemProvider)Items.field_151053_p));
        TEST_TOOLS.put(ToolType.PICKAXE, new ItemStack((IItemProvider)Items.field_151039_o));
    }
}

