/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.util;

public enum Comparison {
    EQUALS("=="),
    NOT_EQUALS("!="),
    GREATER_THAN(">"),
    LESS_THAN("<"),
    GREATER_THAN_OR_EQUAL_TO(">="),
    LESS_THAN_OR_EQUAL_TO("<=");

    private final String symbol;

    private Comparison(String symbol) {
        this.symbol = symbol;
    }

    public static Comparison parseComparison(String versionPredicate) {
        if (versionPredicate.startsWith(Comparison.GREATER_THAN_OR_EQUAL_TO.symbol)) {
            return GREATER_THAN_OR_EQUAL_TO;
        }
        if (versionPredicate.startsWith(Comparison.LESS_THAN_OR_EQUAL_TO.symbol)) {
            return LESS_THAN_OR_EQUAL_TO;
        }
        if (versionPredicate.startsWith(Comparison.GREATER_THAN.symbol)) {
            return GREATER_THAN;
        }
        if (versionPredicate.startsWith(Comparison.LESS_THAN.symbol)) {
            return LESS_THAN;
        }
        if (versionPredicate.startsWith(Comparison.EQUALS.symbol)) {
            return EQUALS;
        }
        if (versionPredicate.startsWith(Comparison.NOT_EQUALS.symbol)) {
            return NOT_EQUALS;
        }
        throw new IllegalArgumentException("Invalid comparison " + versionPredicate);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean satisfies(int compareToResult) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case EQUALS -> {
                if (compareToResult == 0) {
                    yield true;
                }
                yield false;
            }
            case NOT_EQUALS -> {
                if (compareToResult != 0) {
                    yield true;
                }
                yield false;
            }
            case GREATER_THAN -> {
                if (compareToResult > 0) {
                    yield true;
                }
                yield false;
            }
            case LESS_THAN -> {
                if (compareToResult < 0) {
                    yield true;
                }
                yield false;
            }
            case GREATER_THAN_OR_EQUAL_TO -> {
                if (compareToResult >= 0) {
                    yield true;
                }
                yield false;
            }
            case LESS_THAN_OR_EQUAL_TO -> compareToResult <= 0;
        };
    }
}

