/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.json;

import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.json.JsonRepresentable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public record TrimMaterialJson(String assetName, Description description, String ingredient, Float itemModelIndex) implements JsonRepresentable
{
    public TrimMaterialJson(String assetName, String colour, String translate, String ingredient, Float itemModelIndex) {
        this(assetName, new Description(colour, translate), ingredient, itemModelIndex);
    }

    public static TrimMaterialJson fromJson(JsonObject json) {
        return new TrimMaterialJson(JsonHelper.getString(json, "asset_name"), Description.fromJson(JsonHelper.getObject(json, "description")), JsonHelper.getString(json, "ingredient"), JsonHelper.getFloat(json, "item_model_index"));
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("asset_name", this.assetName);
        json.add("description", (JsonElement)this.description.asJson());
        json.addProperty("ingredient", this.ingredient);
        json.addProperty("item_model_index", (Number)this.itemModelIndex);
        return json;
    }

    public record Description(String colour, String translate) implements JsonRepresentable
    {
        public static Description fromJson(JsonObject json) {
            return new Description(JsonHelper.getStringOrElse(json, "color", "#FFFFFF"), JsonHelper.getStringOrElse(json, "translate", ""));
        }

        @Override
        public JsonObject asJson() {
            JsonObject json = new JsonObject();
            json.addProperty("color", this.colour);
            json.addProperty("translate", this.translate);
            return json;
        }
    }
}

