/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.thevortex.allthemodium.worldgen.ATMConfiguredFeature;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class Worldgen {
    public static void addFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.OCEAN && biome.func_201856_r() != Biome.Category.NONE && biome != null) {
                Worldgen.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, ATMConfiguredFeature.ORE_ALLTHEMODIUM);
            }
            if (biome.func_201856_r() == Biome.Category.NETHER && biome.func_201856_r() != Biome.Category.NONE && biome != null) {
                if (biome.getRegistryName().func_110623_a().equals("crimson_forest")) {
                    Worldgen.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, ATMConfiguredFeature.ORE_VIBRANIUM);
                }
                if (biome.getRegistryName().func_110623_a().equals("warped_forest")) {
                    Worldgen.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, ATMConfiguredFeature.ORE_VIBRANIUM);
                }
                Worldgen.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, ATMConfiguredFeature.SOUL_LAVA_SPRING);
            }
            if (biome.func_201856_r() != Biome.Category.THEEND || biome.func_201856_r() == Biome.Category.NONE || biome == null || !biome.getRegistryName().func_110623_a().equals("end_highlands")) continue;
            Worldgen.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, ATMConfiguredFeature.ORE_UNOBTAINIUM);
        }
    }

    public static void addFeatureToBiome(Biome biome, GenerationStage.Decoration feature, ConfiguredFeature<?, ?> configuredFeature) {
        Worldgen.ConvertImmutableFeatures(biome);
        List biomeFeatures = biome.func_242440_e().field_242484_f;
        while (biomeFeatures.size() <= feature.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        ((List)biomeFeatures.get(feature.ordinal())).add(() -> configuredFeature);
    }

    private static void ConvertImmutableFeatures(Biome biome) {
        if (biome.func_242440_e().field_242484_f instanceof ImmutableList) {
            biome.func_242440_e().field_242484_f = biome.func_242440_e().field_242484_f.stream().map(Lists::newArrayList).collect(Collectors.toList());
        }
    }
}

