/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.AllTheModium;
import com.thevortex.allthemodium.fluids.FluidList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;

public class FluidBlock
extends FlowingFluidBlock {
    public int tickcount = 0;

    public FluidBlock(Supplier<? extends FlowingFluid> supplier, AbstractBlock.Properties p_i48368_1_) {
        super(supplier, p_i48368_1_);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return false;
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        ++this.tickcount;
        if (this.tickcount == 20) {
            this.func_225542_b_(state, worldIn, pos, rand);
            this.tickcount = 0;
        }
    }

    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return false;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public void randomTick(World p_207186_1_, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!p_207186_1_.func_82736_K().func_223586_b(GameRules.field_223598_a)) break block7;
            int i = random.nextInt(10);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    BlockState FIRE;
                    if (!p_207186_1_.func_175623_d(blockpos = blockpos.func_177982_a(random.nextInt(10) - 1, 1, random.nextInt(10) - 1))) {
                        return;
                    }
                    BlockState blockstate = p_207186_1_.func_180495_p(blockpos);
                    BlockState blockState = FIRE = SoulFireBlock.func_235577_c_((Block)blockstate.func_177230_c()) ? Blocks.field_235335_bO_.func_176223_P() : ((FireBlock)Blocks.field_150480_ab).func_176223_P();
                    if (blockstate.func_196958_f()) {
                        if (!this.isSurroundingBlockFlammable((IWorldReader)p_207186_1_, blockpos)) continue;
                        p_207186_1_.func_175656_a(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_207186_1_, (BlockPos)blockpos, (BlockPos)pos, (BlockState)FIRE));
                        return;
                    }
                    if (!blockstate.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 10; ++k) {
                    BlockState FIRE;
                    BlockPos blockpos1 = pos.func_177982_a(random.nextInt(10) - 1, 0, random.nextInt(10) - 1);
                    BlockState blockState = FIRE = SoulFireBlock.func_235577_c_((Block)p_207186_1_.func_180495_p(blockpos1).func_177230_c()) ? Blocks.field_235335_bO_.func_176223_P() : ((FireBlock)Blocks.field_150480_ab).func_176223_P();
                    if (!p_207186_1_.func_175623_d(blockpos1)) {
                        return;
                    }
                    if (!p_207186_1_.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn((IWorldReader)p_207186_1_, blockpos1)) continue;
                    p_207186_1_.func_175656_a(blockpos1.func_177984_a(), ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_207186_1_, (BlockPos)blockpos1.func_177984_a(), (BlockPos)pos, (BlockState)FIRE));
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    private boolean getCanBlockBurn(IWorldReader worldIn, BlockPos pos) {
        return (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || worldIn.func_201671_F(pos)) && worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Random rand = new Random();
        this.randomTick(worldIn, pos, state.func_204520_s(), rand);
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    private boolean reactWithNeighbors(World worldIn, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            if (direction != Direction.DOWN) {
                blockpos = pos.func_177971_a(direction.func_176730_m());
                if (worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    Block block = worldIn.func_204610_c(blockpos).func_206889_d() ? Blocks.field_235399_ni_ : Blocks.field_150343_Z;
                    worldIn.func_175656_a(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)blockpos, (BlockPos)blockpos, (BlockState)block.func_176223_P()));
                    return false;
                }
                if (worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b)) {
                    Block block = worldIn.func_204610_c(blockpos).func_206889_d() ? Blocks.field_235406_np_ : Blocks.field_150424_aL;
                    worldIn.func_175656_a(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)blockpos, (BlockPos)blockpos, (BlockState)block.func_176223_P()));
                    return false;
                }
            }
            if (direction != Direction.DOWN || !worldIn.func_204610_c(blockpos = pos.func_177971_a(direction.func_176730_m())).func_206884_a((ITag)FluidTags.field_206960_b)) continue;
            Block block = worldIn.func_204610_c(blockpos).func_206889_d() ? Blocks.field_235406_np_ : Blocks.field_150424_aL;
            worldIn.func_175656_a(blockpos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)blockpos, (BlockPos)blockpos, (BlockState)block.func_176223_P()));
            return false;
        }
        return true;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)worldIn));
            FluidBlock.spawnParticles(worldIn, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.func_203425_a((Block)FluidList.molten_BlueLava_block.get())) {
            // empty if block
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    private static void spawnParticles(World world, BlockPos worldIn) {
        double d0 = 0.5625;
        Random random = world.field_73012_v;
        if (world.func_204610_c(worldIn).getFluidState().func_206889_d()) {
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = worldIn.func_177971_a(direction.func_176730_m());
                if (world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) continue;
                Direction.Axis direction$axis = direction.func_176740_k();
                double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
                double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
                double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, (double)worldIn.func_177958_n() + d1, (double)worldIn.func_177956_o() + d2, (double)worldIn.func_177952_p() + d3, (double)random.nextFloat(), (double)random.nextFloat(), (double)random.nextFloat());
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, (double)worldIn.func_177958_n() + d1, (double)worldIn.func_177956_o() + d2, (double)worldIn.func_177952_p() + d3, (double)random.nextFloat(), (double)(-random.nextFloat()), (double)(-random.nextFloat()));
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, (double)worldIn.func_177958_n() + d1, (double)worldIn.func_177956_o() + d2, (double)worldIn.func_177952_p() + d3, (double)(-random.nextFloat()), (double)random.nextFloat(), (double)(-random.nextFloat()));
                world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, (double)worldIn.func_177958_n() + d1, (double)worldIn.func_177956_o() + d2, (double)worldIn.func_177952_p() + d3, (double)(-random.nextFloat()), (double)(-random.nextFloat()), (double)random.nextFloat());
            }
        }
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 1000;
    }

    public void transferPlayer(ServerPlayerEntity player, BlockPos pos) {
        if (player.field_70170_p.field_73011_w.equals(AllTheModium.Mining)) {
            ServerWorld targetWorld = player.field_71133_b.func_71218_a(AllTheModium.OverWorld);
            Teleporter teleporter = targetWorld.func_85176_s();
            player.changeDimension(targetWorld, (ITeleporter)teleporter);
        } else {
            ServerWorld targetWorld = player.field_71133_b.func_71218_a(AllTheModium.Mining);
            Teleporter teleporter = targetWorld.func_85176_s();
            player.changeDimension(targetWorld, (ITeleporter)teleporter);
        }
    }

    public void observedNeighborChange(BlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        if (this.reactWithNeighbors(world, observerPos, observerState)) {
            super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        }
    }
}

