/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static ResourceLocation BLOCK_TEX = AtlasTexture.field_110575_b;

    public static TextureManager engine() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static void bindBlockTexture() {
        RenderUtils.engine().func_110577_a(BLOCK_TEX);
    }

    public void bindTexture(String string) {
        RenderUtils.engine().func_110577_a(new ResourceLocation(string));
    }

    public void bindTexture(ResourceLocation tex) {
        RenderUtils.engine().func_110577_a(tex);
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluidstack) {
        Fluid fluid = fluidstack.getFluid();
        return RenderUtils.getStillTexture(fluidstack.getFluid());
    }

    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        ResourceLocation iconKey = fluid.getAttributes().getStillTexture();
        if (iconKey == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(iconKey);
    }

    public static void renderGuiTank(FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderUtils.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.getAmount() <= 0) {
            return;
        }
        TextureAtlasSprite icon = null;
        if (RenderUtils.getStillTexture(fluid) != null) {
            icon = RenderUtils.getStillTexture(fluid);
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderUtils.bindBlockTexture();
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        RenderSystem.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                float minV = icon.func_94206_g();
                float maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buf = tessellator.func_178180_c();
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_((double)drawX, (double)(drawY + drawHeight), 0.0).func_225583_a_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                buf.func_225582_a_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                buf.func_225582_a_((double)(drawX + drawWidth), (double)drawY, 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).func_181675_d();
                buf.func_225582_a_((double)drawX, (double)drawY, 0.0).func_225583_a_(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        RenderSystem.disableBlend();
    }
}

